/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReplaceConditionalApproxDistinct
implements Rule<AggregationNode> {
    private static final Capture<ProjectNode> SOURCE = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.project().capturedAs(SOURCE)));
    private final StandardFunctionResolution functionResolution;
    private static final String ARBITRARY = "arbitrary";

    public ReplaceConditionalApproxDistinct(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOptimizeConditionalApproxDistinctEnabled(session);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        VariableAllocator variableAllocator = context.getVariableAllocator();
        boolean changed = false;
        ProjectNode project = (ProjectNode)captures.get(SOURCE);
        Assignments.Builder outputs = Assignments.builder();
        Assignments.Builder inputs = Assignments.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry entry : parent.getAggregations().entrySet()) {
            VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)entry.getValue();
            if (!this.isApproxDistinct(aggregation) || !this.aggregationIsReplaceable(aggregation, project.getAssignments())) {
                aggregations.put((Object)variable, (Object)aggregation);
                outputs.put(variable, (RowExpression)variable);
                continue;
            }
            changed = true;
            SpecialFormExpression replaced = (SpecialFormExpression)project.getAssignments().get((VariableReferenceExpression)aggregation.getArguments().get(0));
            VariableReferenceExpression expression = variableAllocator.newVariable("expression", (Type)BigintType.BIGINT);
            inputs.put(expression, this.replaceIfExpression(replaced));
            VariableReferenceExpression intermediate = variableAllocator.newVariable("intermediate", (Type)BigintType.BIGINT);
            aggregations.put((Object)intermediate, (Object)new AggregationNode.Aggregation(new CallExpression(aggregation.getCall().getSourceLocation(), ARBITRARY, this.functionResolution.arbitraryFunction((Type)BigintType.BIGINT), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)expression)), aggregation.getFilter(), aggregation.getOrderBy(), aggregation.isDistinct(), aggregation.getMask()));
            outputs.put(variable, (RowExpression)new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)intermediate, (Object)Expressions.constant(0L, (Type)BigintType.BIGINT))));
        }
        if (!changed) {
            return Rule.Result.empty();
        }
        ProjectNode child = new ProjectNode(project.getSourceLocation(), context.getIdAllocator().getNextId(), project.getSource(), inputs.putAll(project.getAssignments()).build(), project.getLocality());
        AggregationNode aggregation = new AggregationNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)child, (Map)aggregations.build(), parent.getGroupingSets(), (List)ImmutableList.of(), parent.getStep(), parent.getHashVariable(), parent.getGroupIdVariable(), parent.getAggregationId());
        aggregation.getHashVariable().ifPresent(hashvariable -> outputs.put(hashvariable, (RowExpression)hashvariable));
        aggregation.getGroupingSets().getGroupingKeys().forEach(groupingKey -> outputs.put(groupingKey, (RowExpression)groupingKey));
        return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)aggregation, outputs.build()));
    }

    private boolean isApproxDistinct(AggregationNode.Aggregation aggregation) {
        return this.functionResolution.isApproximateCountDistinctFunction(aggregation.getFunctionHandle());
    }

    private ConstantExpression convertConstant(ConstantExpression expression) {
        return Expressions.isNull((RowExpression)expression) ? Expressions.constantNull((Type)BigintType.BIGINT) : Expressions.constant(1L, (Type)BigintType.BIGINT);
    }

    private RowExpression replaceIfExpression(SpecialFormExpression ifCondition) {
        ConstantExpression replace;
        ConstantExpression trueThen = (ConstantExpression)ifCondition.getArguments().get(1);
        ConstantExpression falseThen = (ConstantExpression)ifCondition.getArguments().get(2);
        if (Expressions.isNull((RowExpression)trueThen) && !Expressions.isNull((RowExpression)falseThen) || !Expressions.isNull((RowExpression)trueThen) && Expressions.isNull((RowExpression)falseThen)) {
            replace = new SpecialFormExpression(ifCondition.getSourceLocation(), SpecialFormExpression.Form.IF, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)((RowExpression)ifCondition.getArguments().get(0)), (Object)this.convertConstant(trueThen), (Object)this.convertConstant(falseThen)));
        } else {
            Preconditions.checkState((Expressions.isNull((RowExpression)trueThen) && Expressions.isNull((RowExpression)falseThen) ? 1 : 0) != 0, (String)"expected true (%s) and false (%s) predicates to be null", (Object)trueThen, (Object)falseThen);
            replace = this.convertConstant(trueThen);
        }
        return replace;
    }

    private boolean aggregationIsReplaceable(AggregationNode.Aggregation aggregation, Assignments inputs) {
        RowExpression argument = (RowExpression)aggregation.getArguments().get(0);
        RowExpression ifCondition = null;
        RowExpression trueThen = null;
        RowExpression falseThen = null;
        if (argument instanceof VariableReferenceExpression) {
            ifCondition = inputs.get((VariableReferenceExpression)argument);
        }
        if (ifCondition instanceof SpecialFormExpression && ((SpecialFormExpression)ifCondition).getForm() == SpecialFormExpression.Form.IF) {
            trueThen = (RowExpression)((SpecialFormExpression)ifCondition).getArguments().get(1);
            falseThen = (RowExpression)((SpecialFormExpression)ifCondition).getArguments().get(2);
        }
        return trueThen instanceof ConstantExpression && falseThen instanceof ConstantExpression && (Expressions.isNull(trueThen) || Expressions.isNull(falseThen));
    }
}

