/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.Patterns;

public class RemoveRedundantTopNColumns
implements Rule<TopNNode> {
    private static final Pattern<TopNNode> PATTERN = Patterns.topN().matching(p -> ((GroupReference)p.getSource()).getLogicalProperties().isPresent());

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode node, Captures captures, Rule.Context context) {
        LogicalProperties sourceLogicalProperties;
        OrderingScheme orderingScheme = node.getOrderingScheme();
        OrderingScheme newOrderingScheme = Util.pruneOrderingColumns(orderingScheme, sourceLogicalProperties = ((GroupReference)node.getSource()).getLogicalProperties().get());
        if (newOrderingScheme.equals((Object)orderingScheme)) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode((PlanNode)new TopNNode(node.getSourceLocation(), node.getId(), node.getSource(), node.getCount(), newOrderingScheme, node.getStep()));
    }
}

