/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;

public class RemoveRedundantLimit
implements Rule<LimitNode> {
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(RemoveRedundantLimit::isAtMost);

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    private static boolean isAtMost(LimitNode node) {
        return ((GroupReference)node.getSource()).getLogicalProperties().isPresent() && ((GroupReference)node.getSource()).getLogicalProperties().get().isAtMost(node.getCount());
    }

    @Override
    public Rule.Result apply(LimitNode limit, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(limit.getSource());
    }
}

