/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.google.common.base.Preconditions;

public class RemoveRedundantDistinctLimit
implements Rule<DistinctLimitNode> {
    private static final Pattern<DistinctLimitNode> PATTERN = Pattern.typeOf(DistinctLimitNode.class).matching(RemoveRedundantDistinctLimit::singleRowInput);

    private static boolean singleRowInput(DistinctLimitNode node) {
        return ((GroupReference)node.getSource()).getLogicalProperties().isPresent() && ((GroupReference)node.getSource()).getLogicalProperties().get().isAtMostSingleRow();
    }

    @Override
    public Pattern<DistinctLimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(DistinctLimitNode node, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((!node.getHashVariable().isPresent() ? 1 : 0) != 0, (Object)"HashSymbol should be empty");
        return Rule.Result.ofPlanNode(node.getSource());
    }
}

