/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;

public class RemoveCrossJoinWithConstantInput
implements Rule<JoinNode> {
    private final RowExpressionDeterminismEvaluator rowExpressionDeterminismEvaluator;

    public RemoveCrossJoinWithConstantInput(FunctionAndTypeManager functionAndTypeManager) {
        this.rowExpressionDeterminismEvaluator = new RowExpressionDeterminismEvaluator(functionAndTypeManager);
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return Patterns.join().matching(x -> x.getType().equals((Object)JoinType.INNER) && x.getCriteria().isEmpty());
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isRemoveCrossJoinWithConstantSingleRowInputEnabled(session);
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        PlanNode joinInput;
        PlanNode singleValueInput;
        PlanNode leftInput = context.getLookup().resolve(node.getLeft());
        PlanNode rightInput = context.getLookup().resolve(node.getRight());
        if (this.isOutputSingleConstantRow(rightInput, context)) {
            singleValueInput = rightInput;
            joinInput = leftInput;
        } else if (this.isOutputSingleConstantRow(leftInput, context)) {
            singleValueInput = leftInput;
            joinInput = rightInput;
        } else {
            return Rule.Result.empty();
        }
        Optional<Map<VariableReferenceExpression, RowExpression>> mapping = this.getConstantAssignments(singleValueInput, context);
        if (!mapping.isPresent()) {
            return Rule.Result.empty();
        }
        PlanNode resultNode = PlannerUtils.addProjections(joinInput, context.getIdAllocator(), mapping.get());
        if (node.getFilter().isPresent()) {
            resultNode = new FilterNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), resultNode, (RowExpression)node.getFilter().get());
        }
        return Rule.Result.ofPlanNode(resultNode);
    }

    private boolean isOutputSingleConstantRow(PlanNode planNode, Rule.Context context) {
        while (planNode instanceof ProjectNode) {
            planNode = context.getLookup().resolve(((ProjectNode)planNode).getSource());
        }
        if (planNode instanceof ValuesNode) {
            return ((ValuesNode)planNode).getRows().size() == 1;
        }
        return false;
    }

    private Optional<Map<VariableReferenceExpression, RowExpression>> getConstantAssignments(PlanNode planNode, Rule.Context context) {
        boolean allDeterministic;
        List outputVariables = planNode.getOutputVariables();
        Map<VariableReferenceExpression, RowExpression> mapping = (Map<VariableReferenceExpression, RowExpression>)outputVariables.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity()));
        while (planNode instanceof ProjectNode) {
            Map assignments = ((ProjectNode)planNode).getAssignments().getMap();
            mapping = RemoveCrossJoinWithConstantInput.updateAssignments(mapping, assignments);
            planNode = context.getLookup().resolve(((ProjectNode)planNode).getSource());
        }
        Preconditions.checkState((boolean)(planNode instanceof ValuesNode));
        ValuesNode valuesNode = (ValuesNode)planNode;
        if (!valuesNode.getOutputVariables().isEmpty()) {
            Map assignments = (Map)IntStream.range(0, valuesNode.getOutputVariables().size()).boxed().collect(ImmutableMap.toImmutableMap(idx -> (VariableReferenceExpression)valuesNode.getOutputVariables().get((int)idx), idx -> (RowExpression)((List)valuesNode.getRows().get(0)).get((int)idx)));
            mapping = RemoveCrossJoinWithConstantInput.updateAssignments(mapping, assignments);
        }
        if (allDeterministic = mapping.values().stream().allMatch(this.rowExpressionDeterminismEvaluator::isDeterministic)) {
            return Optional.of(mapping);
        }
        return Optional.empty();
    }

    private static Map<VariableReferenceExpression, RowExpression> updateAssignments(Map<VariableReferenceExpression, RowExpression> mapping, Map<VariableReferenceExpression, RowExpression> newAssignments) {
        return (Map)mapping.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> RowExpressionVariableInliner.inlineVariables(newAssignments, (RowExpression)entry.getValue())));
    }
}

