/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.util.MoreLists;
import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class PruneJoinColumns
extends ProjectOffPushDownRule<JoinNode> {
    public PruneJoinColumns() {
        super(Patterns.join().matching((Predicate)Predicates.not(JoinNode::isCrossJoin)));
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, JoinNode joinNode, Set<VariableReferenceExpression> referencedOutputs) {
        return Optional.of(new JoinNode(joinNode.getSourceLocation(), joinNode.getId(), joinNode.getType(), joinNode.getLeft(), joinNode.getRight(), joinNode.getCriteria(), MoreLists.filteredCopy(joinNode.getOutputVariables(), referencedOutputs::contains), joinNode.getFilter(), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters()));
    }
}

