/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.rule.ProjectOffPushDownRule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneFilterColumns
extends ProjectOffPushDownRule<FilterNode> {
    public PruneFilterColumns() {
        super(Patterns.filter());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, FilterNode filterNode, Set<VariableReferenceExpression> referencedOutputs) {
        Set<VariableReferenceExpression> unique = VariablesExtractor.extractUnique(filterNode.getPredicate());
        Set prunedFilterInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream(), unique.stream()}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(idAllocator, (PlanNode)filterNode, prunedFilterInputs);
    }
}

