/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.optimizations.AggregationNodeUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.Set;
import java.util.stream.Stream;

public class PruneAggregationSourceColumns
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{aggregationNode.getGroupingKeys().stream(), aggregationNode.getHashVariable().map(Stream::of).orElseGet(Stream::empty), aggregationNode.getAggregations().values().stream().flatMap(aggregation -> PruneAggregationSourceColumns.getAggregationInputs(aggregation, TypeProvider.viewOf(context.getVariableAllocator().getVariables())))}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), (PlanNode)aggregationNode, requiredInputs).map(Rule.Result::ofPlanNode).orElseGet(Rule.Result::empty);
    }

    private static Stream<VariableReferenceExpression> getAggregationInputs(AggregationNode.Aggregation aggregation, TypeProvider types) {
        return Streams.concat((Stream[])new Stream[]{AggregationNodeUtils.extractAggregationUniqueVariables(aggregation).stream(), aggregation.getMask().map(Stream::of).orElseGet(Stream::empty)});
    }
}

