/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.DataOrganizationSpecification;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MinMaxByToWindowFunction
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(x -> !x.getHashVariable().isPresent() && !x.getGroupingKeys().isEmpty() && x.getGroupingSetCount() == 1 && x.getStep().equals((Object)AggregationNode.Step.SINGLE));
    private final FunctionResolution functionResolution;

    public MinMaxByToWindowFunction(FunctionAndTypeManager functionAndTypeManager) {
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isRewriteMinMaxByToTopNEnabled(session);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        boolean remainingEmptyOrMinOrMaxOnOrderBy;
        boolean allMaxOrMinByWithSameField;
        Map candidateAggregation;
        boolean isMaxByAggregation;
        Map maxByAggregations = (Map)node.getAggregations().entrySet().stream().filter(x -> this.functionResolution.isMaxByFunction(((AggregationNode.Aggregation)x.getValue()).getFunctionHandle())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map minByAggregations = (Map)node.getAggregations().entrySet().stream().filter(x -> this.functionResolution.isMinByFunction(((AggregationNode.Aggregation)x.getValue()).getFunctionHandle())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (maxByAggregations.isEmpty() && !minByAggregations.isEmpty()) {
            isMaxByAggregation = false;
            candidateAggregation = minByAggregations;
        } else if (!maxByAggregations.isEmpty() && minByAggregations.isEmpty()) {
            isMaxByAggregation = true;
            candidateAggregation = maxByAggregations;
        } else {
            return Rule.Result.empty();
        }
        if (candidateAggregation.values().stream().noneMatch(x -> ((RowExpression)x.getArguments().get(0)).getType() instanceof MapType || ((RowExpression)x.getArguments().get(0)).getType() instanceof ArrayType)) {
            return Rule.Result.empty();
        }
        boolean bl = allMaxOrMinByWithSameField = candidateAggregation.values().stream().map(x -> (RowExpression)x.getArguments().get(1)).distinct().count() == 1L;
        if (!allMaxOrMinByWithSameField) {
            return Rule.Result.empty();
        }
        VariableReferenceExpression orderByVariable = (VariableReferenceExpression)((AggregationNode.Aggregation)candidateAggregation.values().stream().findFirst().get()).getArguments().get(1);
        Map remainingAggregations = (Map)node.getAggregations().entrySet().stream().filter(x -> !candidateAggregation.containsKey(x.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        boolean bl2 = remainingEmptyOrMinOrMaxOnOrderBy = remainingAggregations.isEmpty() || remainingAggregations.size() == 1 && remainingAggregations.values().stream().allMatch(x -> (isMaxByAggregation ? this.functionResolution.isMaxFunction(x.getFunctionHandle()) : this.functionResolution.isMinFunction(x.getFunctionHandle())) && x.getArguments().size() == 1 && ((RowExpression)x.getArguments().get(0)).equals((Object)orderByVariable));
        if (!remainingEmptyOrMinOrMaxOnOrderBy) {
            return Rule.Result.empty();
        }
        List partitionKeys = node.getGroupingKeys();
        OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)new Ordering(orderByVariable, isMaxByAggregation ? SortOrder.DESC_NULLS_LAST : SortOrder.ASC_NULLS_LAST)));
        DataOrganizationSpecification dataOrganizationSpecification = new DataOrganizationSpecification(partitionKeys, Optional.of(orderingScheme));
        VariableReferenceExpression rowNumberVariable = context.getVariableAllocator().newVariable("row_number", (Type)BigintType.BIGINT);
        TopNRowNumberNode topNRowNumberNode = new TopNRowNumberNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getStatsEquivalentPlanNode(), node.getSource(), dataOrganizationSpecification, rowNumberVariable, 1, false, Optional.empty());
        RowExpression equal = Expressions.comparisonExpression(this.functionResolution, OperatorType.EQUAL, (RowExpression)rowNumberVariable, (RowExpression)new ConstantExpression((Object)1L, (Type)BigintType.BIGINT));
        FilterNode filterNode = new FilterNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getStatsEquivalentPlanNode(), (PlanNode)topNRowNumberNode, equal);
        ImmutableMap assignments = ImmutableMap.builder().putAll((Map)node.getAggregations().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, x -> (RowExpression)((AggregationNode.Aggregation)x.getValue()).getArguments().get(0)))).build();
        ProjectNode projectNode = new ProjectNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getStatsEquivalentPlanNode(), (PlanNode)filterNode, Assignments.builder().putAll((Map)assignments).putAll(AssignmentUtils.identityAssignments(node.getGroupingKeys())).build(), ProjectNode.Locality.LOCAL);
        return Rule.Result.ofPlanNode((PlanNode)projectNode);
    }
}

