/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.ExpressionVariableInliner;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

@Deprecated
public class LambdaCaptureDesugaringRewriter {
    public static Expression rewrite(Expression expression, VariableAllocator variableAllocator) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(variableAllocator), (Expression)expression, (Object)new Context());
    }

    private LambdaCaptureDesugaringRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Context> {
        private final VariableAllocator variableAllocator;

        public Visitor(VariableAllocator variableAllocator) {
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        }

        public Expression rewriteLambdaExpression(LambdaExpression node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
            LinkedHashSet<VariableReferenceExpression> referencedVariables = new LinkedHashSet<VariableReferenceExpression>();
            Expression rewrittenBody = treeRewriter.rewrite(node.getBody(), (Object)context.withReferencedVariables(referencedVariables));
            List lambdaArgumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            Set captureVariables = (Set)referencedVariables.stream().filter(variable -> !lambdaArgumentNames.contains(variable.getName())).collect(ImmutableSet.toImmutableSet());
            ImmutableMap.Builder captureVariableToExtraVariable = ImmutableMap.builder();
            ImmutableList.Builder newLambdaArguments = ImmutableList.builder();
            for (VariableReferenceExpression captureVariable : captureVariables) {
                VariableReferenceExpression extraVariable = this.variableAllocator.newVariable(captureVariable);
                captureVariableToExtraVariable.put((Object)captureVariable, (Object)extraVariable);
                newLambdaArguments.add((Object)new LambdaArgumentDeclaration(new Identifier(extraVariable.getName())));
            }
            newLambdaArguments.addAll((Iterable)node.getArguments());
            ImmutableMap variablesMap = captureVariableToExtraVariable.build();
            Function<VariableReferenceExpression, Expression> variableMapping = variable -> ExpressionTreeUtils.createSymbolReference((VariableReferenceExpression)variablesMap.getOrDefault(variable, variable));
            LambdaExpression rewrittenExpression = new LambdaExpression((List)newLambdaArguments.build(), ExpressionVariableInliner.inlineVariables(variableMapping, rewrittenBody, TypeProvider.viewOf(this.variableAllocator.getVariables())));
            if (!captureVariables.isEmpty()) {
                List capturedValues = (List)captureVariables.stream().map(variable -> ExpressionTreeUtils.createSymbolReference(variable)).collect(ImmutableList.toImmutableList());
                rewrittenExpression = new BindExpression(capturedValues, (Expression)rewrittenExpression);
            }
            context.getReferencedVariables().addAll(captureVariables);
            return rewrittenExpression;
        }

        public Expression rewriteSymbolReference(SymbolReference node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
            context.getReferencedVariables().add(PlannerUtils.toVariableReference(this.variableAllocator, (Expression)node));
            return null;
        }
    }

    private static class Context {
        final LinkedHashSet<VariableReferenceExpression> referencedVariables;

        public Context() {
            this(new LinkedHashSet<VariableReferenceExpression>());
        }

        private Context(LinkedHashSet<VariableReferenceExpression> referencedVariables) {
            this.referencedVariables = referencedVariables;
        }

        public LinkedHashSet<VariableReferenceExpression> getReferencedVariables() {
            return this.referencedVariables;
        }

        public Context withReferencedVariables(LinkedHashSet<VariableReferenceExpression> variables) {
            return new Context(variables);
        }
    }
}

