/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InlineProjections
implements Rule<ProjectNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final FunctionResolution functionResolution;

    public InlineProjections(FunctionAndTypeManager functionAndTypeManager) {
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        if (parent.getLocality().equals((Object)ProjectNode.Locality.REMOTE) || child.getLocality().equals((Object)ProjectNode.Locality.REMOTE) || !parent.getLocality().equals((Object)child.getLocality())) {
            return Rule.Result.empty();
        }
        Sets.SetView<VariableReferenceExpression> targets = this.extractInliningTargets(parent, child, context);
        if (targets.isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments assignments = child.getAssignments().filter(arg_0 -> targets.contains(arg_0));
        Map<VariableReferenceExpression, RowExpression> parentAssignments = parent.getAssignments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.inlineReferences((RowExpression)entry.getValue(), assignments)));
        Set<VariableReferenceExpression> inputs = child.getAssignments().entrySet().stream().filter(entry -> targets.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(expression -> VariablesExtractor.extractAll(expression).stream()).collect(Collectors.toSet());
        Assignments.Builder childAssignments = Assignments.builder();
        for (Map.Entry assignment : child.getAssignments().entrySet()) {
            if (targets.contains(assignment.getKey())) continue;
            childAssignments.put(assignment);
        }
        inputs.forEach(input -> childAssignments.put(input, (RowExpression)input));
        return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(parent.getSourceLocation(), parent.getId(), (PlanNode)new ProjectNode(parent.getSourceLocation(), child.getId(), child.getSource(), childAssignments.build(), child.getLocality()), Assignments.copyOf(parentAssignments), parent.getLocality()));
    }

    private RowExpression inlineReferences(RowExpression expression, Assignments assignments) {
        return RowExpressionVariableInliner.inlineVariables(variable -> (RowExpression)assignments.getMap().getOrDefault(variable, variable), expression);
    }

    private Sets.SetView<VariableReferenceExpression> extractInliningTargets(ProjectNode parent, ProjectNode child, Rule.Context context) {
        ImmutableSet childOutputSet = ImmutableSet.copyOf((Collection)child.getOutputVariables());
        TypeProvider types = TypeProvider.viewOf(context.getVariableAllocator().getVariables());
        Map dependencies = parent.getAssignments().getExpressions().stream().flatMap(expression -> VariablesExtractor.extractAll(expression).stream()).filter(((Set)childOutputSet)::contains).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Set constants = dependencies.keySet().stream().filter(input -> InlineProjections.isConstant(child.getAssignments().get(input))).collect(Collectors.toSet());
        Set tryArguments = parent.getAssignments().getExpressions().stream().flatMap(expression -> this.extractTryArguments((RowExpression)expression).stream()).collect(Collectors.toSet());
        Set singletons = dependencies.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).filter(entry -> !tryArguments.contains(entry.getKey())).filter(entry -> !AssignmentUtils.isIdentity(child.getAssignments(), (VariableReferenceExpression)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        return Sets.union(singletons, constants);
    }

    private Set<VariableReferenceExpression> extractTryArguments(RowExpression expression) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        expression.accept((RowExpressionVisitor)new DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<VariableReferenceExpression>>(){

            public Void visitCall(CallExpression call, ImmutableSet.Builder<VariableReferenceExpression> context) {
                if (InlineProjections.this.functionResolution.isTryFunction(call.getFunctionHandle())) {
                    context.addAll(VariablesExtractor.extractAll((RowExpression)call));
                }
                return super.visitCall(call, context);
            }
        }, (Object)builder);
        return builder.build();
    }

    private static boolean isConstant(RowExpression expression) {
        return expression instanceof ConstantExpression;
    }
}

