/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.ExchangeEncoding;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.annotations.VisibleForTesting;

public class DetermineRemotePartitionedExchangeEncoding
implements Rule<ExchangeNode> {
    private static final Pattern<ExchangeNode> PATTERN = Patterns.exchange().with(Patterns.Exchange.scope().equalTo((Object)ExchangeNode.Scope.REMOTE_STREAMING)).with(Patterns.Exchange.type().equalTo((Object)ExchangeNode.Type.REPARTITION));
    private final boolean nativeExecution;
    private final boolean prestoSparkExecutionEnvironment;

    public DetermineRemotePartitionedExchangeEncoding(boolean nativeExecution, boolean prestoSparkExecutionEnvironment) {
        this.nativeExecution = nativeExecution;
        this.prestoSparkExecutionEnvironment = prestoSparkExecutionEnvironment;
    }

    @Override
    public Pattern<ExchangeNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.nativeExecution || this.prestoSparkExecutionEnvironment;
    }

    @Override
    public Rule.Result apply(ExchangeNode node, Captures captures, Rule.Context context) {
        if (this.prestoSparkExecutionEnvironment) {
            return this.determineForPrestoOnSpark(node);
        }
        if (this.nativeExecution) {
            return this.determineForNativeExecution(context.getSession(), node);
        }
        return Rule.Result.empty();
    }

    private Rule.Result determineForPrestoOnSpark(ExchangeNode node) {
        if (node.getPartitioningScheme().isSingleOrBroadcastOrArbitrary()) {
            return Rule.Result.empty();
        }
        if (node.getPartitioningScheme().getEncoding() == ExchangeEncoding.ROW_WISE) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(node.withRowWiseEncoding());
    }

    private Rule.Result determineForNativeExecution(Session session, ExchangeNode node) {
        if (node.getPartitioningScheme().isSingleOrBroadcastOrArbitrary()) {
            return Rule.Result.empty();
        }
        if (node.getPartitioningScheme().getEncoding() == ExchangeEncoding.ROW_WISE) {
            return Rule.Result.empty();
        }
        int minChannelsToPreferRowWiseEncoding = SystemSessionProperties.getMinColumnarEncodingChannelsToPreferRowWiseEncoding(session);
        if (DetermineRemotePartitionedExchangeEncoding.estimateNumberOfOutputColumnarChannels(node) >= (long)minChannelsToPreferRowWiseEncoding) {
            return Rule.Result.ofPlanNode(node.withRowWiseEncoding());
        }
        return Rule.Result.empty();
    }

    @VisibleForTesting
    static long estimateNumberOfOutputColumnarChannels(ExchangeNode node) {
        return node.getOutputVariables().stream().map(VariableReferenceExpression::getType).mapToLong(DetermineRemotePartitionedExchangeEncoding::estimateNumberOfColumnarChannels).sum();
    }

    @VisibleForTesting
    static long estimateNumberOfColumnarChannels(Type type) {
        if (type instanceof FixedWidthType) {
            return 2L;
        }
        if (!type.getTypeParameters().isEmpty()) {
            long result = 2L;
            for (Type parameter : type.getTypeParameters()) {
                result += DetermineRemotePartitionedExchangeEncoding.estimateNumberOfColumnarChannels(parameter);
            }
            return result;
        }
        return 3L;
    }
}

