/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.LocalCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.statistics.HistoryBasedSourceInfo;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.iterative.ConfidenceBasedBroadcastUtil;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.JoinSwappingUtils;
import com.facebook.presto.sql.planner.iterative.rule.PlanNodeWithCost;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DetermineJoinDistributionType
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(joinNode -> !joinNode.getDistributionType().isPresent());
    private final CostComparator costComparator;
    private final TaskCountEstimator taskCountEstimator;
    private String statsSource;

    public DetermineJoinDistributionType(CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public boolean isCostBased(Session session) {
        return SystemSessionProperties.getJoinDistributionType(session) == FeaturesConfig.JoinDistributionType.AUTOMATIC;
    }

    @Override
    public String getStatsSource() {
        return this.statsSource;
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        FeaturesConfig.JoinDistributionType joinDistributionType = SystemSessionProperties.getJoinDistributionType(context.getSession());
        if (joinDistributionType == FeaturesConfig.JoinDistributionType.AUTOMATIC) {
            PlanNode resultNode = this.getCostBasedJoin(joinNode, context);
            this.statsSource = context.getStatsProvider().getStats((PlanNode)joinNode).getSourceInfo().getSourceInfoName();
            return Rule.Result.ofPlanNode(resultNode);
        }
        return Rule.Result.ofPlanNode((PlanNode)this.getSyntacticOrderJoin(joinNode, context, joinDistributionType));
    }

    public static boolean isBelowMaxBroadcastSize(JoinNode joinNode, Rule.Context context) {
        DataSize joinMaxBroadcastTableSize = SystemSessionProperties.getJoinMaxBroadcastTableSize(context.getSession());
        PlanNode buildSide = joinNode.getRight();
        PlanNodeStatsEstimate buildSideStatsEstimate = context.getStatsProvider().getStats(buildSide);
        if (SystemSessionProperties.treatLowConfidenceZeroEstimationAsUnknownEnabled(context.getSession()) && DetermineJoinDistributionType.isLowConfidenceZero(buildSide, context)) {
            return false;
        }
        double buildSideSizeInBytes = buildSideStatsEstimate.getOutputSizeInBytes(buildSide);
        return buildSideSizeInBytes <= (double)joinMaxBroadcastTableSize.toBytes() || SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled(context.getSession()) && DetermineJoinDistributionType.getSourceTablesSizeInBytes(buildSide, context) <= (double)joinMaxBroadcastTableSize.toBytes();
    }

    private PlanNode getCostBasedJoin(JoinNode joinNode, Rule.Context context) {
        Optional<JoinNode> result2;
        Optional<JoinNode> result3;
        ArrayList<PlanNodeWithCost> possibleJoinNodes = new ArrayList<PlanNodeWithCost>();
        this.addJoinsWithDifferentDistributions(joinNode, possibleJoinNodes, context);
        this.addJoinsWithDifferentDistributions(joinNode.flipChildren(), possibleJoinNodes, context);
        if (DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode, context) && DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode.flipChildren(), context) && !DetermineJoinDistributionType.mustPartition(joinNode) && SystemSessionProperties.confidenceBasedBroadcastEnabled(context.getSession()) && (result3 = ConfidenceBasedBroadcastUtil.confidenceBasedBroadcast(joinNode, context)).isPresent()) {
            return (PlanNode)result3.get();
        }
        boolean buildSideLowConfidenceZero = DetermineJoinDistributionType.isLowConfidenceZero(joinNode.getRight(), context);
        boolean probeSideLowConfidenceZero = DetermineJoinDistributionType.isLowConfidenceZero(joinNode.getLeft(), context);
        if ((buildSideLowConfidenceZero || probeSideLowConfidenceZero) && SystemSessionProperties.treatLowConfidenceZeroEstimationAsUnknownEnabled(context.getSession()) && (result2 = ConfidenceBasedBroadcastUtil.treatLowConfidenceZeroEstimationsAsUnknown(probeSideLowConfidenceZero, buildSideLowConfidenceZero, joinNode, context)).isPresent()) {
            return (PlanNode)result2.get();
        }
        if (possibleJoinNodes.stream().anyMatch(result -> result.getCost().hasUnknownComponents()) || possibleJoinNodes.isEmpty()) {
            if (SystemSessionProperties.isUseBroadcastJoinWhenBuildSizeSmallProbeSizeUnknownEnabled(context.getSession()) && possibleJoinNodes.stream().anyMatch(result -> ((JoinDistributionType)((JoinNode)result.getPlanNode()).getDistributionType().get()).equals((Object)JoinDistributionType.REPLICATED))) {
                JoinNode broadcastJoin = (JoinNode)Iterables.getOnlyElement((Iterable)((Iterable)possibleJoinNodes.stream().filter(result -> ((JoinDistributionType)((JoinNode)result.getPlanNode()).getDistributionType().get()).equals((Object)JoinDistributionType.REPLICATED)).map(x -> x.getPlanNode()).collect(ImmutableList.toImmutableList())));
                if (context.getStatsProvider().getStats(broadcastJoin.getBuild()).getSourceInfo() instanceof HistoryBasedSourceInfo) {
                    return broadcastJoin;
                }
            }
            if (SystemSessionProperties.isSizeBasedJoinDistributionTypeEnabled(context.getSession())) {
                return this.getSizeBasedJoin(joinNode, context);
            }
            return this.getSyntacticOrderJoin(joinNode, context, FeaturesConfig.JoinDistributionType.AUTOMATIC);
        }
        Ordering planNodeOrderings = this.costComparator.forSession(context.getSession()).onResultOf(PlanNodeWithCost::getCost);
        return ((PlanNodeWithCost)planNodeOrderings.min(possibleJoinNodes)).getPlanNode();
    }

    private JoinNode getSizeBasedJoin(JoinNode joinNode, Rule.Context context) {
        boolean isRightSideSmall = JoinSwappingUtils.isBelowBroadcastLimit(joinNode.getRight(), context);
        if (isRightSideSmall && !DetermineJoinDistributionType.mustPartition(joinNode)) {
            return joinNode.withDistributionType(JoinDistributionType.REPLICATED);
        }
        boolean isLeftSideSmall = JoinSwappingUtils.isBelowBroadcastLimit(joinNode.getLeft(), context);
        JoinNode flippedJoin = joinNode.flipChildren();
        if (isLeftSideSmall && !DetermineJoinDistributionType.mustPartition(flippedJoin)) {
            return flippedJoin.withDistributionType(JoinDistributionType.REPLICATED);
        }
        if (isRightSideSmall) {
            return joinNode.withDistributionType(JoinDistributionType.PARTITIONED);
        }
        if (isLeftSideSmall) {
            return flippedJoin.withDistributionType(JoinDistributionType.PARTITIONED);
        }
        if (JoinSwappingUtils.isSmallerThanThreshold(joinNode.getRight(), joinNode.getLeft(), context) && !DetermineJoinDistributionType.mustReplicate(joinNode, context)) {
            return joinNode.withDistributionType(JoinDistributionType.PARTITIONED);
        }
        if (JoinSwappingUtils.isSmallerThanThreshold(joinNode.getLeft(), joinNode.getRight(), context) && !DetermineJoinDistributionType.mustReplicate(flippedJoin, context)) {
            return flippedJoin.withDistributionType(JoinDistributionType.PARTITIONED);
        }
        return this.getSyntacticOrderJoin(joinNode, context, FeaturesConfig.JoinDistributionType.AUTOMATIC);
    }

    public static double getSourceTablesSizeInBytes(PlanNode node, Rule.Context context) {
        return DetermineJoinDistributionType.getSourceTablesSizeInBytes(node, context.getLookup(), context.getStatsProvider());
    }

    @VisibleForTesting
    static double getSourceTablesSizeInBytes(PlanNode node, Lookup lookup, StatsProvider statsProvider) {
        boolean hasExpandingNodes = PlanNodeSearcher.searchFrom(node, lookup).whereIsInstanceOfAny(JoinSwappingUtils.EXPANDING_NODE_CLASSES).matches();
        if (hasExpandingNodes) {
            return Double.NaN;
        }
        List sourceNodes = PlanNodeSearcher.searchFrom(node, lookup).whereIsInstanceOfAny((List<Class<? extends PlanNode>>)ImmutableList.of(TableScanNode.class, ValuesNode.class, RemoteSourceNode.class, CteConsumerNode.class)).findAll();
        return sourceNodes.stream().mapToDouble(sourceNode -> statsProvider.getStats((PlanNode)sourceNode).getOutputSizeInBytes((PlanNode)sourceNode)).sum();
    }

    private void addJoinsWithDifferentDistributions(JoinNode joinNode, List<PlanNodeWithCost> possibleJoinNodes, Rule.Context context) {
        if (!DetermineJoinDistributionType.mustPartition(joinNode) && DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode, context)) {
            possibleJoinNodes.add(this.getJoinNodeWithCost(context, joinNode.withDistributionType(JoinDistributionType.REPLICATED)));
        }
        if (!DetermineJoinDistributionType.mustReplicate(joinNode, context) && !joinNode.getCriteria().isEmpty()) {
            possibleJoinNodes.add(this.getJoinNodeWithCost(context, joinNode.withDistributionType(JoinDistributionType.PARTITIONED)));
        }
    }

    private JoinNode getSyntacticOrderJoin(JoinNode joinNode, Rule.Context context, FeaturesConfig.JoinDistributionType joinDistributionType) {
        if (DetermineJoinDistributionType.mustPartition(joinNode)) {
            return joinNode.withDistributionType(JoinDistributionType.PARTITIONED);
        }
        if (DetermineJoinDistributionType.mustReplicate(joinNode, context)) {
            return joinNode.withDistributionType(JoinDistributionType.REPLICATED);
        }
        if (joinDistributionType.canPartition()) {
            return joinNode.withDistributionType(JoinDistributionType.PARTITIONED);
        }
        return joinNode.withDistributionType(JoinDistributionType.REPLICATED);
    }

    public static boolean mustPartition(JoinNode joinNode) {
        return joinNode.getType().mustPartition();
    }

    private static boolean mustReplicate(JoinNode joinNode, Rule.Context context) {
        if (joinNode.getType().mustReplicate(joinNode.getCriteria())) {
            return true;
        }
        return QueryCardinalityUtil.isAtMostScalar(joinNode.getRight(), context.getLookup());
    }

    private PlanNodeWithCost getJoinNodeWithCost(Rule.Context context, JoinNode possibleJoinNode) {
        StatsProvider stats = context.getStatsProvider();
        boolean replicated = ((JoinDistributionType)possibleJoinNode.getDistributionType().get()).equals((Object)JoinDistributionType.REPLICATED);
        int estimatedSourceDistributedTaskCount = this.taskCountEstimator.estimateSourceDistributedTaskCount();
        LocalCostEstimate cost = CostCalculatorWithEstimatedExchanges.calculateJoinCostWithoutOutput(possibleJoinNode.getLeft(), possibleJoinNode.getRight(), stats, replicated, estimatedSourceDistributedTaskCount);
        return new PlanNodeWithCost(cost.toPlanCost(), (PlanNode)possibleJoinNode);
    }

    private static boolean isLowConfidenceZero(PlanNode planNode, Rule.Context context) {
        PlanNodeStatsEstimate statsEstimate = context.getStatsProvider().getStats(planNode);
        return statsEstimate.confidenceLevel() == SourceInfo.ConfidenceLevel.LOW && statsEstimate.getOutputRowCount() == 0.0;
    }
}

