/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AddDistinctForSemiJoinBuild
implements Rule<SemiJoinNode> {
    @Override
    public Pattern<SemiJoinNode> getPattern() {
        return Patterns.semiJoin();
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAddDistinctBelowSemiJoinBuildEnabled(session);
    }

    @Override
    public Rule.Result apply(SemiJoinNode node, Captures captures, Rule.Context context) {
        VariableReferenceExpression filteringSourceVariable;
        PlanNode filterSource = context.getLookup().resolve(node.getFilteringSource());
        if (this.isOutputDistinct(filterSource, filteringSourceVariable = node.getFilteringSourceJoinVariable(), context)) {
            return Rule.Result.empty();
        }
        AggregationNode.GroupingSetDescriptor groupingSetDescriptor = AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)node.getFilteringSourceJoinVariable()));
        AggregationNode distinctAggregation = new AggregationNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), filterSource, (Map)ImmutableMap.of(), groupingSetDescriptor, (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
        return Rule.Result.ofPlanNode(node.replaceChildren((List)ImmutableList.of((Object)node.getSource(), (Object)distinctAggregation)));
    }

    boolean isOutputDistinct(PlanNode node, VariableReferenceExpression output, Rule.Context context) {
        if (node instanceof AggregationNode) {
            AggregationNode aggregationNode = (AggregationNode)node;
            return AggregationNode.isDistinct((AggregationNode)aggregationNode) && aggregationNode.getGroupingKeys().size() == 1 && aggregationNode.getGroupingKeys().contains(output);
        }
        if (node instanceof ProjectNode) {
            ProjectNode projectNode = (ProjectNode)node;
            RowExpression inputExpression = projectNode.getAssignments().get(output);
            if (inputExpression instanceof VariableReferenceExpression) {
                return this.isOutputDistinct(context.getLookup().resolve(projectNode.getSource()), (VariableReferenceExpression)inputExpression, context);
            }
            return false;
        }
        if (node instanceof FilterNode) {
            return this.isOutputDistinct(context.getLookup().resolve(((FilterNode)node).getSource()), output, context);
        }
        return false;
    }
}

