/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class GroupReference
extends InternalPlanNode {
    private final int groupId;
    private final List<VariableReferenceExpression> outputs;
    private final Optional<LogicalProperties> logicalProperties;

    public GroupReference(Optional<SourceLocation> sourceLocation, PlanNodeId id, int groupId, List<VariableReferenceExpression> outputs, Optional<LogicalProperties> logicalProperties) {
        super(sourceLocation, id, Optional.empty());
        this.groupId = groupId;
        this.outputs = ImmutableList.copyOf(outputs);
        this.logicalProperties = logicalProperties;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public List<PlanNode> getSources() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitGroupReference(this, context);
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputs;
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        throw new UnsupportedOperationException();
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Cannot assign canonical plan id to Group Reference node: %s", new Object[]{this}));
    }

    public Optional<LogicalProperties> getLogicalProperties() {
        return this.logicalProperties;
    }
}

