/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class StatsEquivalentPlanNodeWithLimit
extends InternalPlanNode {
    private static final Set<Class<?>> LIMITING_NODES = ImmutableSet.of(LimitNode.class, TopNNode.class, TopNRowNumberNode.class, DistinctLimitNode.class);
    private final PlanNode plan;
    private final PlanNode limit;

    @JsonCreator
    public StatsEquivalentPlanNodeWithLimit(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="plan") PlanNode plan, @JsonProperty(value="limit") PlanNode limit) {
        super(Optional.empty(), id, Optional.empty());
        Preconditions.checkArgument((boolean)LIMITING_NODES.contains(limit.getClass()), (String)"Expected %s to be a limiting node", limit.getClass());
        this.plan = Objects.requireNonNull(plan, "plan is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.plan);
    }

    @JsonProperty
    public PlanNode getPlan() {
        return this.plan;
    }

    @JsonProperty
    public PlanNode getLimit() {
        return this.limit;
    }

    public List<VariableReferenceExpression> getOutputVariables() {
        return this.plan.getOutputVariables();
    }

    @JsonProperty
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unexpected call replaceChildren for %s", new Object[]{this}));
    }

    @JsonProperty
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Cannot assign canonical plan id for: %s", new Object[]{this}));
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitStatsEquivalentPlanNodeWithLimit(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StatsEquivalentPlanNodeWithLimit that = (StatsEquivalentPlanNodeWithLimit)((Object)o);
        return Objects.equals(this.plan, that.plan) && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.limit);
    }
}

