/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.StatisticAggregations;
import com.facebook.presto.spi.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.SqlFunctionUtils;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class StatisticsAggregationPlanner {
    private final VariableAllocator variableAllocator;
    private final FunctionAndTypeResolver functionAndTypeResolver;
    private final boolean useHistograms;
    private final Session session;
    private final FunctionAndTypeManager functionAndTypeManager;

    public StatisticsAggregationPlanner(VariableAllocator variableAllocator, FunctionAndTypeManager functionAndTypeManager, Session session) {
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.functionAndTypeResolver = functionAndTypeManager.getFunctionAndTypeResolver();
        this.useHistograms = SystemSessionProperties.shouldOptimizerUseHistograms(session);
    }

    public TableStatisticAggregation createStatisticsAggregation(TableStatisticsMetadata statisticsMetadata, Map<String, VariableReferenceExpression> columnToVariableMap) {
        StatisticAggregationsDescriptor.Builder descriptor = StatisticAggregationsDescriptor.builder();
        List groupingColumns = statisticsMetadata.getGroupingColumns();
        List groupingVariables = (List)groupingColumns.stream().map(columnToVariableMap::get).collect(ImmutableList.toImmutableList());
        for (int i = 0; i < groupingVariables.size(); ++i) {
            descriptor.addGrouping((String)groupingColumns.get(i), (Object)((VariableReferenceExpression)groupingVariables.get(i)));
        }
        ImmutableMap.Builder additionalVariables = ImmutableMap.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        FunctionResolution functionResolution = new FunctionResolution(this.functionAndTypeResolver);
        for (TableStatisticType type : statisticsMetadata.getTableStatistics()) {
            if (type != TableStatisticType.ROW_COUNT) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table-wide statistic type not supported: " + type);
            }
            AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(new CallExpression("count", functionResolution.countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, Optional.empty());
            VariableReferenceExpression variable = this.variableAllocator.newVariable("rowCount", (Type)BigintType.BIGINT);
            aggregations.put((Object)variable, (Object)aggregation);
            descriptor.addTableStatistic(TableStatisticType.ROW_COUNT, (Object)variable);
        }
        for (ColumnStatisticMetadata columnStatisticMetadata : statisticsMetadata.getColumnStatistics()) {
            if (!this.useHistograms && columnStatisticMetadata.getStatisticType() == ColumnStatisticType.HISTOGRAM) continue;
            String columnName = columnStatisticMetadata.getColumnName();
            ColumnStatisticType statisticType = columnStatisticMetadata.getStatisticType();
            VariableReferenceExpression inputVariable = columnToVariableMap.get(columnName);
            Verify.verify((inputVariable != null ? 1 : 0) != 0, (String)"inputVariable is null", (Object[])new Object[0]);
            ColumnStatisticsAggregation aggregation = this.createColumnAggregation(columnStatisticMetadata, inputVariable, (Map<String, String>)ImmutableMap.of((Object)columnName, (Object)inputVariable.getName()));
            additionalVariables.putAll(aggregation.getInputProjections());
            VariableReferenceExpression variable = this.variableAllocator.newVariable(statisticType + ":" + columnName, aggregation.getOutputType());
            aggregations.put((Object)variable, (Object)aggregation.getAggregation());
            descriptor.addColumnStatistic(columnStatisticMetadata, (Object)variable);
        }
        StatisticAggregations aggregation = new StatisticAggregations((Map)aggregations.build(), groupingVariables);
        return new TableStatisticAggregation(aggregation, descriptor.build(), (Map)additionalVariables.build());
    }

    private ColumnStatisticsAggregation createColumnAggregationFromSqlFunction(String sqlFunction, VariableReferenceExpression input, Map<String, String> columnNameToInputVariableNameMap) {
        RowExpression expression = SqlFunctionUtils.sqlFunctionToRowExpression(sqlFunction, (Set<VariableReferenceExpression>)ImmutableSet.of((Object)input), this.functionAndTypeManager, this.session, columnNameToInputVariableNameMap);
        Verify.verify((boolean)(expression instanceof CallExpression), (String)"column statistic SQL expressions must represent a function call", (Object[])new Object[0]);
        CallExpression call = (CallExpression)expression;
        FunctionMetadata functionMeta = this.functionAndTypeResolver.getFunctionMetadata(call.getFunctionHandle());
        Verify.verify((boolean)functionMeta.getFunctionKind().equals((Object)FunctionKind.AGGREGATE), (String)"column statistic function must be aggregates", (Object[])new Object[0]);
        ImmutableMap.Builder inputProjections = ImmutableMap.builder();
        List callVariableArguments = call.getArguments().stream().map(argument -> {
            if (argument instanceof VariableReferenceExpression) {
                return argument;
            }
            VariableReferenceExpression newArgument = this.variableAllocator.newVariable(argument);
            inputProjections.put((Object)newArgument, argument);
            return newArgument;
        }).collect(Collectors.toList());
        CallExpression callWithVariables = new CallExpression(call.getSourceLocation(), call.getDisplayName(), call.getFunctionHandle(), call.getType(), callVariableArguments);
        return new ColumnStatisticsAggregation(new AggregationNode.Aggregation(callWithVariables, Optional.empty(), Optional.empty(), false, Optional.empty()), this.functionAndTypeResolver.getType(functionMeta.getReturnType()), (Map)inputProjections.build());
    }

    private ColumnStatisticsAggregation createColumnAggregationFromFunctionName(ColumnStatisticMetadata columnStatisticMetadata, VariableReferenceExpression input) {
        FunctionHandle functionHandle = this.functionAndTypeResolver.lookupFunction(columnStatisticMetadata.getFunction(), TypeSignatureProvider.fromTypes((List)ImmutableList.builder().add((Object)input.getType()).build()));
        FunctionMetadata functionMeta = this.functionAndTypeResolver.getFunctionMetadata(functionHandle);
        Type inputType = this.functionAndTypeResolver.getType((TypeSignature)Iterables.getOnlyElement((Iterable)functionMeta.getArgumentTypes()));
        Type outputType = this.functionAndTypeResolver.getType(functionMeta.getReturnType());
        boolean isVarcharType = input.getType().getTypeSignature().getBase().equals("varchar");
        boolean isTypeSignatureBaseMatching = inputType.getTypeSignature().getBase().equals(input.getType().getTypeSignature().getBase());
        Verify.verify((inputType.equals(input.getType()) || input.getType().equals(UnknownType.UNKNOWN) || SystemSessionProperties.isNativeExecutionEnabled(this.session) && isVarcharType && isTypeSignatureBaseMatching ? 1 : 0) != 0, (String)"resolved function input type does not match the input type: %s != %s", (Object)inputType, (Object)input.getType());
        return new ColumnStatisticsAggregation(new AggregationNode.Aggregation(new CallExpression(input.getSourceLocation(), columnStatisticMetadata.getFunction(), functionHandle, outputType, (List)ImmutableList.of((Object)input)), Optional.empty(), Optional.empty(), false, Optional.empty()), outputType, (Map)ImmutableMap.of());
    }

    private ColumnStatisticsAggregation createColumnAggregation(ColumnStatisticMetadata columnStatisticMetadata, VariableReferenceExpression input, Map<String, String> columnNameToInputVariableNameMap) {
        if (columnStatisticMetadata.isSqlExpression()) {
            return this.createColumnAggregationFromSqlFunction(columnStatisticMetadata.getFunction(), input, columnNameToInputVariableNameMap);
        }
        return this.createColumnAggregationFromFunctionName(columnStatisticMetadata, input);
    }

    public static class ColumnStatisticsAggregation {
        private final AggregationNode.Aggregation aggregation;
        private final Type outputType;
        private final Map<VariableReferenceExpression, RowExpression> inputProjections;

        private ColumnStatisticsAggregation(AggregationNode.Aggregation aggregation, Type outputType, Map<VariableReferenceExpression, RowExpression> inputProjections) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
            this.outputType = Objects.requireNonNull(outputType, "outputType is null");
            this.inputProjections = Objects.requireNonNull(inputProjections, "additionalVariable is null");
        }

        public AggregationNode.Aggregation getAggregation() {
            return this.aggregation;
        }

        public Type getOutputType() {
            return this.outputType;
        }

        public Map<VariableReferenceExpression, RowExpression> getInputProjections() {
            return this.inputProjections;
        }
    }

    public static class TableStatisticAggregation {
        private final StatisticAggregations aggregations;
        private final StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor;
        private final Map<VariableReferenceExpression, RowExpression> additionalVariables;

        private TableStatisticAggregation(StatisticAggregations aggregations, StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor, Map<VariableReferenceExpression, RowExpression> additionalVariables) {
            this.aggregations = Objects.requireNonNull(aggregations, "statisticAggregations is null");
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
            this.additionalVariables = Objects.requireNonNull(additionalVariables, "additionalVariables is null");
        }

        public StatisticAggregations getAggregations() {
            return this.aggregations;
        }

        public StatisticAggregationsDescriptor<VariableReferenceExpression> getDescriptor() {
            return this.descriptor;
        }

        public Map<VariableReferenceExpression, RowExpression> getAdditionalVariables() {
            return this.additionalVariables;
        }
    }
}

