/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DeleteNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.MergeJoinNode;
import com.facebook.presto.spi.plan.MetadataDeleteNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SortNode;
import com.facebook.presto.spi.plan.SpatialJoinNode;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableFinishNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.UnnestNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.split.SampledSplitSource;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.split.SplitSourceProvider;
import com.facebook.presto.sql.planner.LazySplitSource;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UpdateNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class SplitSourceFactory {
    private static final Logger log = Logger.get(SplitSourceFactory.class);
    private final SplitSourceProvider splitSourceProvider;
    private final WarningCollector warningCollector;

    public SplitSourceFactory(SplitSourceProvider splitSourceProvider, WarningCollector warningCollector) {
        this.splitSourceProvider = Objects.requireNonNull(splitSourceProvider, "splitSourceProvider is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Map<PlanNodeId, SplitSource> createSplitSources(PlanFragment fragment, Session session, TableWriteInfo tableWriteInfo) {
        ImmutableList.Builder splitSources = ImmutableList.builder();
        try {
            return (Map)fragment.getRoot().accept((PlanVisitor)new Visitor(session, fragment.getStageExecutionDescriptor(), splitSources), (Object)new Context(tableWriteInfo));
        }
        catch (Throwable t) {
            splitSources.build().forEach(SplitSourceFactory::closeSplitSource);
            throw t;
        }
    }

    private static void closeSplitSource(SplitSource source) {
        try {
            source.close();
        }
        catch (Throwable t) {
            log.warn(t, "Error closing split source");
        }
    }

    private static ConnectorSplitManager.SplitSchedulingStrategy getSplitSchedulingStrategy(StageExecutionDescriptor stageExecutionDescriptor, PlanNodeId scanNodeId) {
        if (stageExecutionDescriptor.isRecoverableGroupedExecution()) {
            return ConnectorSplitManager.SplitSchedulingStrategy.REWINDABLE_GROUPED_SCHEDULING;
        }
        if (stageExecutionDescriptor.isScanGroupedExecution(scanNodeId)) {
            return ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING;
        }
        return ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING;
    }

    private final class Visitor
    extends InternalPlanVisitor<Map<PlanNodeId, SplitSource>, Context> {
        private final Session session;
        private final StageExecutionDescriptor stageExecutionDescriptor;
        private final ImmutableList.Builder<SplitSource> splitSources;

        private Visitor(Session session, StageExecutionDescriptor stageExecutionDescriptor, ImmutableList.Builder<SplitSource> allSplitSources) {
            this.session = session;
            this.stageExecutionDescriptor = stageExecutionDescriptor;
            this.splitSources = allSplitSources;
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitExplainAnalyze(ExplainAnalyzeNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitTableScan(TableScanNode node, Context context) {
            TableHandle table = node.getTable();
            Supplier<SplitSource> splitSourceSupplier = () -> SplitSourceFactory.this.splitSourceProvider.getSplits(this.session, table, SplitSourceFactory.getSplitSchedulingStrategy(this.stageExecutionDescriptor, node.getId()), SplitSourceFactory.this.warningCollector);
            LazySplitSource splitSource = new LazySplitSource(splitSourceSupplier);
            this.splitSources.add((Object)splitSource);
            return ImmutableMap.of((Object)node.getId(), (Object)splitSource);
        }

        public Map<PlanNodeId, SplitSource> visitJoin(JoinNode node, Context context) {
            Map leftSplits = (Map)node.getLeft().accept((PlanVisitor)this, (Object)context);
            Map rightSplits = (Map)node.getRight().accept((PlanVisitor)this, (Object)context);
            return ImmutableMap.builder().putAll(leftSplits).putAll(rightSplits).build();
        }

        public Map<PlanNodeId, SplitSource> visitMergeJoin(MergeJoinNode node, Context context) {
            Map leftSplits = (Map)node.getLeft().accept((PlanVisitor)this, (Object)context);
            Map rightSplits = (Map)node.getRight().accept((PlanVisitor)this, (Object)context);
            return ImmutableMap.builder().putAll(leftSplits).putAll(rightSplits).build();
        }

        public Map<PlanNodeId, SplitSource> visitSemiJoin(SemiJoinNode node, Context context) {
            Map sourceSplits = (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
            Map filteringSourceSplits = (Map)node.getFilteringSource().accept((PlanVisitor)this, (Object)context);
            return ImmutableMap.builder().putAll(sourceSplits).putAll(filteringSourceSplits).build();
        }

        public Map<PlanNodeId, SplitSource> visitSpatialJoin(SpatialJoinNode node, Context context) {
            Map leftSplits = (Map)node.getLeft().accept((PlanVisitor)this, (Object)context);
            Map rightSplits = (Map)node.getRight().accept((PlanVisitor)this, (Object)context);
            return ImmutableMap.builder().putAll(leftSplits).putAll(rightSplits).build();
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitIndexJoin(IndexJoinNode node, Context context) {
            return (Map)node.getProbeSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitRemoteSource(RemoteSourceNode node, Context context) {
            return ImmutableMap.of();
        }

        public Map<PlanNodeId, SplitSource> visitValues(ValuesNode node, Context context) {
            return ImmutableMap.of();
        }

        public Map<PlanNodeId, SplitSource> visitFilter(FilterNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitSample(SampleNode node, Context context) {
            switch (node.getSampleType()) {
                case BERNOULLI: {
                    return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
                }
                case SYSTEM: {
                    Map nodeSplits = (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
                    if (nodeSplits.size() == 1) {
                        PlanNodeId planNodeId = (PlanNodeId)Iterables.getOnlyElement(nodeSplits.keySet());
                        SampledSplitSource sampledSplitSource = new SampledSplitSource((SplitSource)nodeSplits.get(planNodeId), node.getSampleRatio());
                        return ImmutableMap.of((Object)planNodeId, (Object)sampledSplitSource);
                    }
                    return nodeSplits;
                }
            }
            throw new UnsupportedOperationException("Sampling is not supported for type " + (Object)((Object)node.getSampleType()));
        }

        public Map<PlanNodeId, SplitSource> visitAggregation(AggregationNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitGroupId(GroupIdNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitMarkDistinct(MarkDistinctNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitWindow(WindowNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitRowNumber(RowNumberNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitTopNRowNumber(TopNRowNumberNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitProject(ProjectNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitUnnest(UnnestNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitTopN(TopNNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitOutput(OutputNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitEnforceSingleRow(EnforceSingleRowNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitAssignUniqueId(AssignUniqueId node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitLimit(LimitNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitDistinctLimit(DistinctLimitNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitSort(SortNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitTableWriter(TableWriterNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitTableWriteMerge(TableWriterMergeNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitTableFinish(TableFinishNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitStatisticsWriterNode(StatisticsWriterNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitDelete(DeleteNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitUpdate(UpdateNode node, Context context) {
            return (Map)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        public Map<PlanNodeId, SplitSource> visitMetadataDelete(MetadataDeleteNode node, Context context) {
            return ImmutableMap.of();
        }

        public Map<PlanNodeId, SplitSource> visitUnion(UnionNode node, Context context) {
            return this.processSources(node.getSources(), context);
        }

        @Override
        public Map<PlanNodeId, SplitSource> visitExchange(ExchangeNode node, Context context) {
            return this.processSources(node.getSources(), context);
        }

        private Map<PlanNodeId, SplitSource> processSources(List<PlanNode> sources, Context context) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (PlanNode child : sources) {
                result.putAll((Map)child.accept((PlanVisitor)this, (Object)context));
            }
            return result.build();
        }

        public Map<PlanNodeId, SplitSource> visitPlan(PlanNode node, Context context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }
    }

    private static class Context {
        private final TableWriteInfo tableWriteInfo;

        public Context(TableWriteInfo tableWriteInfo) {
            this.tableWriteInfo = tableWriteInfo;
        }

        public TableWriteInfo getTableWriteInfo() {
            return this.tableWriteInfo;
        }
    }
}

