/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.RuleStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public class RuleStatsRecorder {
    private final Map<Class<?>, RuleStats> stats = new HashMap();

    public void registerAll(Collection<Rule<?>> rules) {
        for (Rule<?> rule : rules) {
            Preconditions.checkArgument((!rule.getClass().isAnonymousClass() ? 1 : 0) != 0);
            this.stats.put(rule.getClass(), new RuleStats());
        }
    }

    public void record(Rule<?> rule, long nanos, boolean match) {
        this.stats.get(rule.getClass()).record(nanos, match);
    }

    public void recordFailure(Rule<?> rule) {
        this.stats.get(rule.getClass()).recordFailure();
    }

    public void export(MBeanExporter exporter) {
        for (Map.Entry<Class<?>, RuleStats> entry : this.stats.entrySet()) {
            Verify.verify((!entry.getKey().getSimpleName().isEmpty() ? 1 : 0) != 0);
            String name = ObjectNames.builder(IterativeOptimizer.class).withProperty("rule", entry.getKey().getSimpleName()).build();
            try {
                exporter.export(name, (Object)entry.getValue());
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to export MBean with name '%s'", name), e);
            }
        }
    }

    public void unexport(MBeanExporter exporter) {
        for (Class<?> rule : this.stats.keySet()) {
            String name = ObjectNames.builder(IterativeOptimizer.class).withProperty("rule", rule.getSimpleName()).build();
            exporter.unexport(name);
        }
    }
}

