/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Output;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OutputExtractor {
    public Optional<Output> extractOutput(PlanNode root) {
        Visitor visitor = new Visitor();
        root.accept((PlanVisitor)visitor, null);
        if (visitor.getConnectorId() == null) {
            return Optional.empty();
        }
        return Optional.of(new Output(visitor.getConnectorId(), visitor.getSchemaTableName().getSchemaName(), visitor.getSchemaTableName().getTableName(), "", Optional.of(ImmutableList.copyOf(visitor.getColumns()))));
    }

    private class Visitor
    extends InternalPlanVisitor<Void, Void> {
        private ConnectorId connectorId;
        private SchemaTableName schemaTableName;
        private List<Column> columns = new ArrayList<Column>();

        private Visitor() {
        }

        public Void visitTableWriter(TableWriterNode node, Void context) {
            TableWriterNode.WriterTarget writerTarget = (TableWriterNode.WriterTarget)node.getTarget().orElseThrow(() -> new VerifyException("target is absent"));
            this.connectorId = writerTarget.getConnectorId();
            Preconditions.checkState((this.schemaTableName == null || this.schemaTableName.equals((Object)writerTarget.getSchemaTableName()) ? 1 : 0) != 0, (Object)"cannot have more than a single create, insert or delete in a query");
            this.schemaTableName = writerTarget.getSchemaTableName();
            Preconditions.checkArgument((node.getColumnNames().size() == node.getColumns().size() ? 1 : 0) != 0, (Object)"Column names and columns sizes must be equal");
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                this.columns.add(new Column((String)node.getColumnNames().get(i), ((VariableReferenceExpression)node.getColumns().get(i)).getType().toString()));
            }
            return null;
        }

        @Override
        public Void visitSequence(SequenceNode node, Void context) {
            node.getPrimarySource().accept((PlanVisitor)this, (Object)context);
            return null;
        }

        public Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept((PlanVisitor)this, (Object)context);
            }
            return null;
        }

        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        public List<Column> getColumns() {
            return this.columns;
        }
    }
}

