/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NullabilityAnalyzer {
    private final FunctionAndTypeManager functionAndTypeManager;
    private final FunctionResolution functionResolution;

    public NullabilityAnalyzer(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    public boolean mayReturnNullOnNonNullInput(RowExpression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        expression.accept((com.facebook.presto.spi.relation.RowExpressionVisitor)new RowExpressionVisitor(this.functionAndTypeManager, this.functionResolution), (Object)result);
        return result.get();
    }

    private static class RowExpressionVisitor
    extends DefaultRowExpressionTraversalVisitor<AtomicBoolean> {
        private final FunctionAndTypeManager functionAndTypeManager;
        private final FunctionResolution functionResolution;

        public RowExpressionVisitor(FunctionAndTypeManager functionAndTypeManager, FunctionResolution functionResolution) {
            this.functionAndTypeManager = functionAndTypeManager;
            this.functionResolution = functionResolution;
        }

        public Void visitCall(CallExpression call, AtomicBoolean result) {
            block10: {
                FunctionMetadata function;
                block9: {
                    function = this.functionAndTypeManager.getFunctionMetadata(call.getFunctionHandle());
                    Optional operator = function.getOperatorType();
                    if (!operator.isPresent()) break block9;
                    switch ((OperatorType)operator.get()) {
                        case SATURATED_FLOOR_CAST: 
                        case CAST: {
                            if (!this.isCastTypeOnlyCoercion(call)) {
                                result.set(true);
                                break;
                            }
                            break block10;
                        }
                        case SUBSCRIPT: {
                            result.set(true);
                            break;
                        }
                    }
                    break block10;
                }
                if (this.functionResolution.isTryCastFunction(call.getFunctionHandle())) {
                    if (!this.isCastTypeOnlyCoercion(call)) {
                        result.set(true);
                    }
                } else if (!this.functionReturnsNullForNotNullInput(function)) {
                    result.set(true);
                }
            }
            call.getArguments().forEach(argument -> argument.accept((com.facebook.presto.spi.relation.RowExpressionVisitor)this, (Object)result));
            return null;
        }

        private boolean isCastTypeOnlyCoercion(CallExpression castCallExpression) {
            Preconditions.checkArgument((castCallExpression.getArguments().size() == 1 ? 1 : 0) != 0);
            Type sourceType = ((RowExpression)castCallExpression.getArguments().get(0)).getType();
            Type targetType = castCallExpression.getType();
            return this.functionAndTypeManager.isTypeOnlyCoercion(sourceType, targetType);
        }

        private boolean functionReturnsNullForNotNullInput(FunctionMetadata function) {
            return function.getName().getObjectName().equalsIgnoreCase("like");
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, AtomicBoolean result) {
            switch (specialForm.getForm()) {
                case IN: 
                case IF: 
                case SWITCH: 
                case WHEN: 
                case NULL_IF: 
                case DEREFERENCE: {
                    result.set(true);
                }
            }
            specialForm.getArguments().forEach(argument -> argument.accept((com.facebook.presto.spi.relation.RowExpressionVisitor)this, (Object)result));
            return null;
        }
    }
}

