/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.FixedBucketNodeMap;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public class NodePartitionMap {
    private final List<InternalNode> partitionToNode;
    private final int[] bucketToPartition;
    private final ToIntFunction<Split> splitToBucket;
    private final boolean cacheable;

    public NodePartitionMap(List<InternalNode> partitionToNode, ToIntFunction<Split> splitToBucket) {
        this.partitionToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionToNode, "partitionToNode is null"));
        this.bucketToPartition = IntStream.range(0, partitionToNode.size()).toArray();
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
        this.cacheable = false;
    }

    public NodePartitionMap(List<InternalNode> partitionToNode, int[] bucketToPartition, ToIntFunction<Split> splitToBucket, boolean cacheable) {
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
        this.partitionToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionToNode, "partitionToNode is null"));
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
        this.cacheable = cacheable;
    }

    public List<InternalNode> getPartitionToNode() {
        return this.partitionToNode;
    }

    public int[] getBucketToPartition() {
        return this.bucketToPartition;
    }

    public InternalNode getNode(Split split) {
        int bucket = this.splitToBucket.applyAsInt(split);
        int partition = this.bucketToPartition[bucket];
        return Objects.requireNonNull(this.partitionToNode.get(partition));
    }

    public BucketNodeMap asBucketNodeMap() {
        ImmutableList.Builder bucketToNode = ImmutableList.builder();
        for (int partition : this.bucketToPartition) {
            bucketToNode.add((Object)this.partitionToNode.get(partition));
        }
        return new FixedBucketNodeMap(this.splitToBucket, (List<InternalNode>)bucketToNode.build(), this.cacheable);
    }
}

