/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.AnalyzedExpressionRewriter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Deprecated
public class DesugarAtTimeZoneRewriter {
    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes), (Expression)expression, null);
    }

    private DesugarAtTimeZoneRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, SqlParser sqlParser, VariableAllocator variableAllocator) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        return new AnalyzedExpressionRewriter(session, metadata, sqlParser, TypeProvider.viewOf(variableAllocator.getVariables())).rewriteWith(Visitor::new, expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes) {
            this.expressionTypes = Objects.requireNonNull(expressionTypes, "expressionTypes is null");
        }

        public Expression rewriteAtTimeZone(AtTimeZone node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            Type type = this.expressionTypes.get(NodeRef.of((Node)node.getValue()));
            if (type.equals(TimeType.TIME)) {
                value = new Cast(value, TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.getDisplayName());
            } else if (type.equals(TimestampType.TIMESTAMP)) {
                value = new Cast(value, TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.getDisplayName());
            }
            return new FunctionCall(QualifiedName.of((String)"at_timezone"), (List)ImmutableList.of((Object)value, (Object)treeRewriter.rewrite(node.getTimeZone(), (Object)context)));
        }
    }
}

