/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;

public class IfCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 3 ? 1 : 0) != 0);
        Variable wasNull = context.wasNull();
        LabelNode falseLabel = new LabelNode("false");
        LabelNode endLabel = new LabelNode("end");
        BytecodeBlock block = new BytecodeBlock().append(context.generate(arguments.get(0), Optional.empty()));
        IfStatement ifStatement = new IfStatement("... and condition value was not null", new Object[0]).condition((BytecodeNode)wasNull);
        ifStatement.ifTrue().putVariable(wasNull, false).pop(Boolean.TYPE).gotoLabel(falseLabel);
        ifStatement.ifFalse().ifFalseGoto(falseLabel).append(context.generate(arguments.get(1), Optional.empty())).gotoLabel(endLabel);
        block.append((BytecodeNode)ifStatement).visitLabel(falseLabel).append(context.generate(arguments.get(2), Optional.empty()));
        block.visitLabel(endLabel);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(context, returnType, output)));
        return block;
    }
}

