/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.expressions;

import com.facebook.presto.FullConnectorSession;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.nodeManager.PluginNodeManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.ExpressionOptimizerProvider;
import com.facebook.presto.spi.sql.planner.ExpressionOptimizerContext;
import com.facebook.presto.spi.sql.planner.ExpressionOptimizerFactory;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionOptimizer;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

public class ExpressionOptimizerManager
implements ExpressionOptimizerProvider {
    public static final String DEFAULT_EXPRESSION_OPTIMIZER_NAME = "default";
    private static final File EXPRESSION_MANAGER_CONFIGURATION_DIRECTORY = new File("etc/expression-manager/");
    private static final String EXPRESSION_MANAGER_FACTORY_NAME = "expression-manager-factory.name";
    private final NodeManager nodeManager;
    private final FunctionAndTypeManager functionAndTypeManager;
    private final FunctionResolution functionResolution;
    private final File configurationDirectory;
    private final Map<String, ExpressionOptimizerFactory> expressionOptimizerFactories = new ConcurrentHashMap<String, ExpressionOptimizerFactory>();
    private final Map<String, ExpressionOptimizer> expressionOptimizers = new ConcurrentHashMap<String, ExpressionOptimizer>();

    @Inject
    public ExpressionOptimizerManager(PluginNodeManager nodeManager, FunctionAndTypeManager functionAndTypeManager) {
        this(nodeManager, functionAndTypeManager, EXPRESSION_MANAGER_CONFIGURATION_DIRECTORY);
    }

    public ExpressionOptimizerManager(PluginNodeManager nodeManager, FunctionAndTypeManager functionAndTypeManager, File configurationDirectory) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
        this.configurationDirectory = Objects.requireNonNull(configurationDirectory, "configurationDirectory is null");
        this.expressionOptimizers.put(DEFAULT_EXPRESSION_OPTIMIZER_NAME, new RowExpressionOptimizer(functionAndTypeManager));
    }

    public void loadExpressionOptimizerFactories() {
        try {
            for (File file : ExpressionOptimizerManager.listFiles(this.configurationDirectory)) {
                if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
                this.loadExpressionOptimizerFactory(file);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load expression manager configuration", e);
        }
    }

    private void loadExpressionOptimizerFactory(File configurationFile) throws IOException {
        String name = Files.getNameWithoutExtension((String)configurationFile.getName());
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"File name is empty, full path: %s", (Object)configurationFile.getAbsolutePath());
        Preconditions.checkArgument((!name.equals(DEFAULT_EXPRESSION_OPTIMIZER_NAME) ? 1 : 0) != 0, (String)"Cannot name an expression optimizer instance %s", (Object)DEFAULT_EXPRESSION_OPTIMIZER_NAME);
        HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(configurationFile));
        String factoryName = (String)properties.remove(EXPRESSION_MANAGER_FACTORY_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)factoryName) ? 1 : 0) != 0, (String)"%s does not contain %s", (Object)configurationFile, (Object)EXPRESSION_MANAGER_FACTORY_NAME);
        Preconditions.checkArgument((boolean)this.expressionOptimizerFactories.containsKey(factoryName), (String)"ExpressionOptimizerFactory %s is not registered, registered factories: ", (Object)factoryName, this.expressionOptimizerFactories.keySet());
        ExpressionOptimizer optimizer = this.expressionOptimizerFactories.get(factoryName).createOptimizer(properties, new ExpressionOptimizerContext(this.nodeManager, (FunctionMetadataManager)this.functionAndTypeManager, (StandardFunctionResolution)this.functionResolution));
        this.expressionOptimizers.put(name, optimizer);
    }

    public void addExpressionOptimizerFactory(ExpressionOptimizerFactory expressionOptimizerFactory) {
        String name = expressionOptimizerFactory.getName();
        Preconditions.checkArgument((this.expressionOptimizerFactories.putIfAbsent(name, expressionOptimizerFactory) == null ? 1 : 0) != 0, (String)"ExpressionOptimizerFactory %s is already registered", (Object)name);
    }

    public ExpressionOptimizer getExpressionOptimizer(ConnectorSession connectorSession) {
        Preconditions.checkArgument((boolean)(connectorSession instanceof FullConnectorSession), (Object)"connectorSession is not an instance of FullConnectorSession");
        Session session = ((FullConnectorSession)connectorSession).getSession();
        String expressionOptimizerName = SystemSessionProperties.getExpressionOptimizerName(session);
        Preconditions.checkArgument((boolean)this.expressionOptimizers.containsKey(expressionOptimizerName), (String)"ExpressionOptimizer '%s' is not registered", (Object)expressionOptimizerName);
        return this.expressionOptimizers.get(expressionOptimizerName);
    }

    private static List<File> listFiles(File directory) {
        Object[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

