/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.sql.analyzer.MetadataHandle;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.util.AnalyzerUtil;
import com.facebook.presto.util.MetadataUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class MetadataExtractor {
    private final Metadata metadata;
    private final MetadataResolver metadataResolver;
    private final Optional<ExecutorService> executor;
    private final SqlParser sqlParser;
    private final WarningCollector warningCollector;

    public MetadataExtractor(Session session, Metadata metadata, Optional<ExecutorService> metadataExtractorExecutor, SqlParser sqlParser, WarningCollector warningCollector) {
        this.metadata = Objects.requireNonNull(metadata, "metadataResolver is null");
        this.metadataResolver = Objects.requireNonNull(metadata.getMetadataResolver(session), "metadataResolver is null");
        this.executor = Objects.requireNonNull(metadataExtractorExecutor, "metadataExtractorExecutor is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public void populateMetadataHandle(Session session, Statement statement, MetadataHandle metadataHandle) {
        if (this.executor.isPresent() && SystemSessionProperties.isPreProcessMetadataCalls(session).booleanValue()) {
            metadataHandle.setPreProcessMetadataCalls(true);
            this.populateMetadataHandle(session, statement, metadataHandle, new MetadataExtractorContext());
        }
    }

    private void populateMetadataHandle(Session session, Statement statement, MetadataHandle metadataHandle, MetadataExtractorContext metadataExtractorContext) {
        Visitor visitor = new Visitor(session);
        visitor.process((Node)statement, metadataExtractorContext);
        metadataExtractorContext.getTableNames().forEach(tableName -> {
            if (tableName.getObjectName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, "Table name is empty", new Object[0]);
            }
            if (tableName.getSchemaName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, "Schema name is empty", new Object[0]);
            }
            metadataHandle.addViewDefinition(tableName, this.executor.get().submit(() -> {
                Optional optionalView = (Optional)session.getRuntimeStats().recordWallTime("getViewTimeNanos", () -> this.metadataResolver.getView(tableName));
                if (optionalView.isPresent()) {
                    ViewDefinition view = (ViewDefinition)optionalView.get();
                    Statement viewStatement = this.sqlParser.createStatement(view.getOriginalSql(), AnalyzerUtil.createParsingOptions(session, this.warningCollector));
                    Session.SessionBuilder viewSessionBuilder = Session.builder(this.metadata.getSessionPropertyManager()).setQueryId(session.getQueryId()).setTransactionId(session.getTransactionId().orElse(null)).setIdentity(session.getIdentity()).setSource(session.getSource().orElse(null)).setCatalog(view.getCatalog().orElse(null)).setSchema(view.getSchema().orElse(null)).setTimeZoneKey(session.getTimeZoneKey()).setLocale(session.getLocale()).setRemoteUserAddress(session.getRemoteUserAddress().orElse(null)).setUserAgent(session.getUserAgent().orElse(null)).setClientInfo(session.getClientInfo().orElse(null)).setStartTime(session.getStartTime());
                    this.populateMetadataHandle(viewSessionBuilder.build(), viewStatement, metadataHandle, new MetadataExtractorContext(Optional.of(metadataExtractorContext)));
                }
                return optionalView;
            }));
            metadataHandle.addMaterializedViewDefinition(tableName, this.executor.get().submit(() -> {
                Optional optionalMaterializedView = (Optional)session.getRuntimeStats().recordWallTime("getMaterializedViewTimeNanos", () -> this.metadataResolver.getMaterializedView(tableName));
                if (optionalMaterializedView.isPresent()) {
                    Statement materializedViewStatement = this.sqlParser.createStatement(((MaterializedViewDefinition)optionalMaterializedView.get()).getOriginalSql(), AnalyzerUtil.createParsingOptions(session, this.warningCollector));
                    this.populateMetadataHandle(session, materializedViewStatement, metadataHandle, new MetadataExtractorContext(Optional.of(metadataExtractorContext)));
                }
                return optionalMaterializedView;
            }));
            metadataHandle.addTableColumnMetadata(tableName, this.executor.get().submit(() -> MetadataUtils.getTableColumnMetadata(session, this.metadataResolver, tableName)));
        });
    }

    private class MetadataExtractorContext {
        private final Optional<MetadataExtractorContext> parent;
        private final Set<QualifiedObjectName> tableNames;
        private final Set<Identifier> tableNamesToSkipProcessing;

        public MetadataExtractorContext() {
            this.parent = Optional.empty();
            this.tableNames = new HashSet<QualifiedObjectName>();
            this.tableNamesToSkipProcessing = new HashSet<Identifier>();
        }

        public MetadataExtractorContext(Optional<MetadataExtractorContext> parent) {
            this.parent = parent;
            this.tableNames = new HashSet<QualifiedObjectName>();
            this.tableNamesToSkipProcessing = new HashSet<Identifier>();
        }

        public void addTable(QualifiedObjectName tableName) {
            if (!this.tableExists(tableName)) {
                this.tableNames.add(tableName);
            }
        }

        private boolean tableExists(QualifiedObjectName tableName) {
            return this.tableNames.contains(tableName) || this.parent.map(metadataExtractorContext -> metadataExtractorContext.tableExists(tableName)).orElse(false) != false;
        }

        public Set<QualifiedObjectName> getTableNames() {
            return this.tableNames;
        }

        public void addTableNameToSkipProcessing(Identifier commonTableExpressionName) {
            if (!this.shouldSkipProcessing(commonTableExpressionName)) {
                this.tableNamesToSkipProcessing.add(commonTableExpressionName);
            }
        }

        public boolean shouldSkipProcessing(Identifier tableName) {
            return this.tableNamesToSkipProcessing.contains(tableName) || this.parent.map(metadataExtractorContext -> metadataExtractorContext.shouldSkipProcessing(tableName)).orElse(false) != false;
        }
    }

    private class Visitor
    extends DefaultTraversalVisitor<Void, MetadataExtractorContext> {
        private final Session session;

        public Visitor(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        protected Void visitTable(Table table, MetadataExtractorContext context) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)table, table.getName(), MetadataExtractor.this.metadata);
            if (tableName.getObjectName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table name is empty", new Object[0]);
            }
            if (tableName.getSchemaName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)table, "Schema name is empty", new Object[0]);
            }
            if (!context.shouldSkipProcessing(new Identifier(tableName.getObjectName()))) {
                context.addTable(tableName);
            }
            return (Void)super.visitTable(table, (Object)context);
        }

        protected Void visitInsert(Insert insert, MetadataExtractorContext context) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)insert, insert.getTarget(), MetadataExtractor.this.metadata);
            if (tableName.getObjectName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)insert, "Table name is empty", new Object[0]);
            }
            if (tableName.getSchemaName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)insert, "Schema name is empty", new Object[0]);
            }
            context.addTable(tableName);
            return (Void)super.visitInsert(insert, (Object)context);
        }

        protected Void visitDelete(Delete node, MetadataExtractorContext context) {
            Table table = node.getTable();
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)table, table.getName(), MetadataExtractor.this.metadata);
            if (tableName.getObjectName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table name is empty", new Object[0]);
            }
            if (tableName.getSchemaName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)node, "Schema name is empty", new Object[0]);
            }
            context.addTable(tableName);
            return (Void)super.visitDelete(node, (Object)context);
        }

        protected Void visitAnalyze(Analyze node, MetadataExtractorContext context) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getTableName(), MetadataExtractor.this.metadata);
            if (tableName.getObjectName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table name is empty", new Object[0]);
            }
            if (tableName.getSchemaName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)node, "Schema name is empty", new Object[0]);
            }
            context.addTable(tableName);
            return (Void)super.visitAnalyze(node, (Object)context);
        }

        protected Void visitWith(With node, MetadataExtractorContext context) {
            node.getQueries().forEach(query -> {
                context.addTableNameToSkipProcessing(query.getName());
                this.process((Node)query, context);
            });
            return null;
        }
    }
}

