/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.MaterializedViewUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.MaterializedViewInformationExtractor;
import com.facebook.presto.sql.analyzer.MaterializedViewRewriteQueryShapeValidator;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.facebook.presto.util.AnalyzerUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MaterializedViewQueryOptimizer
extends AstVisitor<Node, Void> {
    private static final Logger log = Logger.get(MaterializedViewQueryOptimizer.class);
    private final Metadata metadata;
    private final Session session;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final RowExpressionDomainTranslator domainTranslator;
    private final LogicalRowExpressions logicalRowExpressions;
    private final MetadataResolver metadataResolver;

    public MaterializedViewQueryOptimizer(Metadata metadata, Session session, SqlParser sqlParser, AccessControl accessControl, RowExpressionDomainTranslator domainTranslator) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sql parser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "access control is null");
        this.domainTranslator = Objects.requireNonNull(domainTranslator, "row expression domain translator is null");
        this.metadataResolver = Objects.requireNonNull(metadata.getMetadataResolver(session), "metadataResolver is null");
        FunctionAndTypeManager functionAndTypeManager = metadata.getFunctionAndTypeManager();
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver()), (FunctionMetadataManager)functionAndTypeManager);
    }

    protected Node visitQuerySpecification(QuerySpecification node, Void context) {
        if (!node.getFrom().isPresent()) {
            return node;
        }
        Relation from = (Relation)node.getFrom().get();
        if (from instanceof Table) {
            return this.rewriteQuerySpecificationIfCompatible(node, (Table)from);
        }
        if (from instanceof AliasedRelation && ((AliasedRelation)from).getRelation() instanceof Table) {
            return this.rewriteQuerySpecificationIfCompatible(node, (Table)((AliasedRelation)from).getRelation());
        }
        Relation newFrom = this.processSameType(from);
        if (from == newFrom) {
            return node;
        }
        return new QuerySpecification(node.getSelect(), Optional.of(newFrom), node.getWhere(), node.getGroupBy(), node.getHaving(), node.getOrderBy(), node.getOffset(), node.getLimit());
    }

    protected Node visitNode(Node node, Void context) {
        return node;
    }

    protected Node visitQuery(Query node, Void context) {
        boolean withSame;
        QueryBody newQueryBody = this.processSameType(node.getQueryBody());
        Optional<With> newWith = node.getWith().map(this::processSameType);
        boolean bl = withSame = !newWith.isPresent() || node.getWith().get() == newWith.get();
        if (withSame && node.getQueryBody() == newQueryBody) {
            return node;
        }
        return new Query(newWith, newQueryBody, node.getOrderBy(), node.getOffset(), node.getLimit());
    }

    protected Node visitUnion(Union node, Void context) {
        List newRelations = this.processNodes(node.getRelations());
        if (node.getRelations() == newRelations) {
            return node;
        }
        return new Union(newRelations, node.isDistinct());
    }

    protected Node visitIntersect(Intersect node, Void context) {
        List newRelations = this.processNodes(node.getRelations());
        if (node.getRelations() == newRelations) {
            return node;
        }
        return new Intersect(newRelations, node.isDistinct());
    }

    protected Node visitExcept(Except node, Void context) {
        Relation newLeft = this.processSameType(node.getLeft());
        Relation newRight = this.processSameType(node.getRight());
        if (newLeft == node.getLeft() && newRight == node.getRight()) {
            return node;
        }
        return new Except(newLeft, newRight, node.isDistinct());
    }

    protected Node visitLateral(Lateral node, Void context) {
        Query newQuery = this.processSameType(node.getQuery());
        if (node.getQuery() == newQuery) {
            return node;
        }
        return new Lateral(newQuery);
    }

    protected Node visitTableSubquery(TableSubquery node, Void context) {
        Query newQuery = this.processSameType(node.getQuery());
        if (node.getQuery() == newQuery) {
            return node;
        }
        return new TableSubquery(this.processSameType(newQuery));
    }

    protected Node visitAliasedRelation(AliasedRelation node, Void context) {
        Relation newRelation = this.processSameType(node.getRelation());
        if (node.getRelation() == newRelation) {
            return node;
        }
        return new AliasedRelation(this.processSameType(newRelation), node.getAlias(), node.getColumnNames());
    }

    protected Node visitSampledRelation(SampledRelation node, Void context) {
        Relation newRelation = this.processSameType(node.getRelation());
        if (node.getRelation() == newRelation) {
            return node;
        }
        return new SampledRelation(newRelation, node.getType(), node.getSamplePercentage());
    }

    protected Node visitJoin(Join node, Void context) {
        Relation newLeft = this.processSameType(node.getLeft());
        Relation newRight = this.processSameType(node.getRight());
        if (node.getLeft() == newLeft && node.getRight() == newRight) {
            return node;
        }
        return new Join(node.getType(), newLeft, newRight, node.getCriteria());
    }

    protected Node visitWith(With node, Void context) {
        List newWithQueries = this.processNodes(node.getQueries());
        if (node.getQueries() == newWithQueries) {
            return node;
        }
        return new With(node.isRecursive(), newWithQueries);
    }

    protected Node visitWithQuery(WithQuery node, Void context) {
        Query newQuery = this.processSameType(node.getQuery());
        if (node.getQuery() == newQuery) {
            return node;
        }
        return new WithQuery(node.getName(), this.processSameType(node.getQuery()), node.getColumnNames());
    }

    private <T extends Node> List<T> processNodes(List<T> nodes) {
        ArrayList<T> newNodes = new ArrayList<T>();
        boolean listsIdentical = true;
        for (Node node : nodes) {
            Node newNode;
            if (node != (newNode = this.processSameType(node))) {
                listsIdentical = false;
            }
            newNodes.add(newNode);
        }
        return listsIdentical ? nodes : newNodes;
    }

    private <T extends Node> T processSameType(T node) {
        return (T)((Node)this.process(node));
    }

    private QuerySpecification rewriteQuerySpecificationIfCompatible(QuerySpecification querySpecification, Table baseTable) {
        Optional<String> errorMessage = MaterializedViewRewriteQueryShapeValidator.validate(querySpecification);
        if (errorMessage.isPresent()) {
            log.warn("Rewrite failed for base table %s with error message { %s }. ", new Object[]{baseTable.getName(), errorMessage.get()});
            return querySpecification;
        }
        List<QualifiedObjectName> referencedMaterializedViews = this.metadata.getReferencedMaterializedViews(this.session, MetadataUtil.createQualifiedObjectName(this.session, (Node)baseTable, baseTable.getName(), this.metadata));
        for (QualifiedObjectName materializedViewName : referencedMaterializedViews) {
            QuerySpecification rewrittenQuerySpecification = this.getRewrittenQuerySpecification(materializedViewName, querySpecification);
            if (rewrittenQuerySpecification == querySpecification) continue;
            return rewrittenQuerySpecification;
        }
        return querySpecification;
    }

    private QuerySpecification getRewrittenQuerySpecification(QualifiedObjectName materializedViewName, QuerySpecification originalQuerySpecification) {
        MaterializedViewDefinition materializedViewDefinition = (MaterializedViewDefinition)this.metadataResolver.getMaterializedView(materializedViewName).orElseThrow(() -> new IllegalStateException("Materialized view definition not present in metadata as expected."));
        Table materializedViewTable = new Table(QualifiedName.of((String)materializedViewDefinition.getTable()));
        Query materializedViewQuery = (Query)this.sqlParser.createStatement(materializedViewDefinition.getOriginalSql(), AnalyzerUtil.createParsingOptions(this.session));
        return new QuerySpecificationRewriter(materializedViewTable, materializedViewQuery, materializedViewName).rewrite(originalQuerySpecification);
    }

    private class QuerySpecificationRewriter
    extends AstVisitor<Node, Void> {
        private final Table materializedView;
        private final Query materializedViewQuery;
        private final QualifiedObjectName materializedViewName;
        private MaterializedViewInformationExtractor.MaterializedViewInfo materializedViewInfo;
        private Optional<Identifier> removablePrefix = Optional.empty();
        private Optional<Set<Expression>> expressionsInGroupBy = Optional.empty();

        QuerySpecificationRewriter(Table materializedView, Query materializedViewQuery, QualifiedObjectName materializedViewName) {
            this.materializedView = Objects.requireNonNull(materializedView, "materialized view is null");
            this.materializedViewQuery = Objects.requireNonNull(materializedViewQuery, "materialized view query is null");
            this.materializedViewName = Objects.requireNonNull(materializedViewName, "materialized view name is null");
        }

        public QuerySpecification rewrite(QuerySpecification querySpecification) {
            try {
                MaterializedViewInformationExtractor materializedViewInformationExtractor = new MaterializedViewInformationExtractor();
                materializedViewInformationExtractor.process((Node)this.materializedViewQuery);
                this.materializedViewInfo = materializedViewInformationExtractor.getMaterializedViewInfo();
                QuerySpecification rewrittenQuerySpecification = (QuerySpecification)this.process((Node)querySpecification);
                if (rewrittenQuerySpecification == querySpecification) {
                    return querySpecification;
                }
                if (!SystemSessionProperties.isMaterializedViewDataConsistencyEnabled(MaterializedViewQueryOptimizer.this.session)) {
                    MaterializedViewQueryOptimizer.this.session.getRuntimeStats().addMetricValue("optimizedWithMaterializedViewSubqueryCount", RuntimeUnit.NONE, 1L);
                    return rewrittenQuerySpecification;
                }
                MaterializedViewStatus materializedViewStatus = this.getMaterializedViewStatus(querySpecification);
                if (materializedViewStatus.isPartiallyMaterialized() || materializedViewStatus.isFullyMaterialized()) {
                    MaterializedViewQueryOptimizer.this.session.getRuntimeStats().addMetricValue("optimizedWithMaterializedViewSubqueryCount", RuntimeUnit.NONE, 1L);
                    return rewrittenQuerySpecification;
                }
                MaterializedViewQueryOptimizer.this.session.getRuntimeStats().addMetricValue("manyPartitionsMissingInMaterializedViewCount", RuntimeUnit.NONE, 1L);
                return querySpecification;
            }
            catch (Exception e) {
                return querySpecification;
            }
        }

        protected Node visitNode(Node node, Void context) {
            for (Node child : node.getChildren()) {
                this.process(child, context);
            }
            return node;
        }

        protected Node visitQuery(Query node, Void context) {
            return new Query(node.getWith(), (QueryBody)this.process((Node)node.getQueryBody(), context), node.getOrderBy(), node.getOffset(), node.getLimit());
        }

        protected Node visitQuerySpecification(QuerySpecification node, Void context) {
            if (!node.getFrom().isPresent()) {
                throw new IllegalArgumentException("visitQuerySpecification should not be invoked for an empty FROM clause");
            }
            Relation relation = (Relation)node.getFrom().get();
            if (relation instanceof AliasedRelation) {
                this.removablePrefix = Optional.of(((AliasedRelation)relation).getAlias());
                relation = ((AliasedRelation)relation).getRelation();
            }
            if (!(relation instanceof Table)) {
                throw new IllegalArgumentException("visitQuerySpecification should not be invoked for a non-table FROM clause");
            }
            Table baseTable = (Table)relation;
            if (!this.removablePrefix.isPresent()) {
                this.removablePrefix = Optional.of(new Identifier(baseTable.getName().toString()));
            }
            if (node.getGroupBy().isPresent()) {
                ImmutableSet.Builder expressionsInGroupByBuilder = ImmutableSet.builder();
                for (GroupingElement element : ((GroupBy)node.getGroupBy().get()).getGroupingElements()) {
                    element = ExpressionUtils.removeGroupingElementPrefix(element, this.removablePrefix);
                    Optional<Set<Expression>> groupByOfMaterializedView = this.materializedViewInfo.getGroupBy();
                    if (groupByOfMaterializedView.isPresent()) {
                        for (Expression expression : element.getExpressions()) {
                            if (groupByOfMaterializedView.get().contains(expression) && this.materializedViewInfo.getBaseToViewColumnMap().containsKey(expression)) continue;
                            throw new IllegalStateException(String.format("Grouping element %s is not present in materialized view groupBy field", element));
                        }
                    }
                    expressionsInGroupByBuilder.addAll((Iterable)element.getExpressions());
                }
                this.expressionsInGroupBy = Optional.of(expressionsInGroupByBuilder.build());
            }
            if (node.getHaving().isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Having clause is not supported in query optimizer", new Object[0]);
            }
            if (this.materializedViewInfo.getWhereClause().isPresent()) {
                if (!node.getWhere().isPresent()) {
                    throw new IllegalStateException("Query with no where clause is not rewritable by materialized view with where clause");
                }
                Scope scope = this.extractScope(baseTable, node, this.materializedViewInfo.getWhereClause().get());
                RowExpression materializedViewWhereCondition = this.convertToRowExpression(this.materializedViewInfo.getWhereClause().get(), scope);
                RowExpression baseQueryWhereCondition = this.convertToRowExpression((Expression)node.getWhere().get(), scope);
                RowExpression rewriteLogicExpression = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{baseQueryWhereCondition, Expressions.call((Optional<SourceLocation>)baseQueryWhereCondition.getSourceLocation(), "not", new FunctionResolution(MaterializedViewQueryOptimizer.this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()).notFunction(), materializedViewWhereCondition.getType(), materializedViewWhereCondition)});
                RowExpression disjunctiveNormalForm = MaterializedViewQueryOptimizer.this.logicalRowExpressions.convertToDisjunctiveNormalForm(rewriteLogicExpression);
                DomainTranslator.ExtractionResult result = MaterializedViewQueryOptimizer.this.domainTranslator.fromPredicate(MaterializedViewQueryOptimizer.this.session.toConnectorSession(), disjunctiveNormalForm, DomainTranslator.BASIC_COLUMN_EXTRACTOR);
                if (!result.getTupleDomain().equals((Object)TupleDomain.none())) {
                    throw new IllegalStateException("View filter condition does not contain base query's filter condition");
                }
            }
            return new QuerySpecification((Select)this.process((Node)node.getSelect(), context), node.getFrom().map(from -> (Relation)this.process((Node)from, context)), node.getWhere().map(where -> (Expression)this.process((Node)where, context)), node.getGroupBy().map(groupBy -> (GroupBy)this.process((Node)groupBy, context)), node.getHaving().map(having -> (Expression)this.process((Node)having, context)), node.getOrderBy().map(orderBy -> (OrderBy)this.process((Node)orderBy, context)), node.getOffset(), node.getLimit());
        }

        protected Node visitSelect(Select node, Void context) {
            if (this.materializedViewInfo.isDistinct() && !node.isDistinct()) {
                throw new IllegalStateException("Materialized view has distinct and base query does not");
            }
            ImmutableList.Builder rewrittenSelectItems = ImmutableList.builder();
            for (SelectItem selectItem : node.getSelectItems()) {
                rewrittenSelectItems.add((Object)((SelectItem)this.process((Node)selectItem, context)));
            }
            return new Select(node.isDistinct(), (List)rewrittenSelectItems.build());
        }

        protected Node visitSingleColumn(SingleColumn node, Void context) {
            node = ExpressionUtils.removeSingleColumnPrefix(node, this.removablePrefix);
            Expression expression = node.getExpression();
            Optional<Set<Expression>> groupByOfMaterializedView = this.materializedViewInfo.getGroupBy();
            if (groupByOfMaterializedView.isPresent() && this.validateExpressionForGroupBy(groupByOfMaterializedView.get(), expression) && (!this.expressionsInGroupBy.isPresent() || !this.expressionsInGroupBy.get().contains(expression))) {
                throw new IllegalStateException("Query a column presents in materialized view group by: " + expression.toString());
            }
            Expression processedColumn = (Expression)this.process((Node)expression, context);
            Optional<Identifier> alias = node.getAlias();
            if (!alias.isPresent() && processedColumn instanceof Identifier && !processedColumn.equals((Object)node.getExpression())) {
                alias = Optional.of((Identifier)node.getExpression());
            }
            return new SingleColumn(processedColumn, (Optional)alias);
        }

        protected Node visitAllColumns(AllColumns node, Void context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "All columns rewrite is not supported in query optimizer", new Object[0]);
        }

        protected Node visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return new ArithmeticBinaryExpression(node.getOperator(), (Expression)this.process((Node)node.getLeft(), context), (Expression)this.process((Node)node.getRight(), context));
        }

        protected Node visitIdentifier(Identifier node, Void context) {
            if (!this.materializedViewInfo.getBaseToViewColumnMap().containsKey(node)) {
                throw new IllegalStateException("Materialized view definition does not contain mapping for the column: " + node.getValue());
            }
            return new Identifier(this.materializedViewInfo.getBaseToViewColumnMap().get(node).getValue(), node.isDelimited());
        }

        protected Node visitExpression(Expression node, Void context) {
            return (Node)super.visitExpression(ExpressionUtils.removeExpressionPrefix(node, this.removablePrefix), (Object)context);
        }

        protected Node visitFunctionCall(FunctionCall node, Void context) {
            ImmutableList.Builder rewrittenArguments = ImmutableList.builder();
            Map<Expression, Identifier> baseToViewColumnMap = this.materializedViewInfo.getBaseToViewColumnMap();
            if (MaterializedViewUtils.NON_ASSOCIATIVE_REWRITE_FUNCTIONS.containsKey(node.getName())) {
                return MaterializedViewUtils.rewriteNonAssociativeFunction(node, baseToViewColumnMap);
            }
            if (!MaterializedViewUtils.ASSOCIATIVE_REWRITE_FUNCTIONS.contains(node.getName())) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Was unable to rewrite non-associative function call with materialized view", new Object[0]);
            }
            if (baseToViewColumnMap.containsKey(node)) {
                Identifier derivedColumn = baseToViewColumnMap.get(node);
                if (node.getName().equals((Object)MaterializedViewUtils.COUNT)) {
                    return this.rewriteCountAsSum(node, (Expression)derivedColumn);
                }
                rewrittenArguments.add((Object)derivedColumn);
            } else {
                for (Expression argument : node.getArguments()) {
                    rewrittenArguments.add((Object)((Expression)this.process((Node)argument, context)));
                }
            }
            return new FunctionCall(node.getName(), node.getWindow(), node.getFilter(), node.getOrderBy(), node.isDistinct(), node.isIgnoreNulls(), (List)rewrittenArguments.build());
        }

        protected Node visitAliasedRelation(AliasedRelation node, Void context) {
            return this.visitRelation(node.getRelation(), context);
        }

        protected Node visitRelation(Relation node, Void context) {
            if (this.materializedViewInfo.getBaseTable().isPresent() && node.equals((Object)this.materializedViewInfo.getBaseTable().get())) {
                return this.materializedView;
            }
            throw new IllegalStateException("Mismatching table or non-supporting relation format in base query");
        }

        protected Node visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return new LogicalBinaryExpression(node.getOperator(), (Expression)this.process((Node)node.getLeft(), context), (Expression)this.process((Node)node.getRight(), context));
        }

        protected Node visitComparisonExpression(ComparisonExpression node, Void context) {
            return new ComparisonExpression(node.getOperator(), (Expression)this.process((Node)node.getLeft(), context), (Expression)this.process((Node)node.getRight(), context));
        }

        protected Node visitGroupBy(GroupBy node, Void context) {
            ImmutableList.Builder rewrittenGroupBy = ImmutableList.builder();
            for (GroupingElement element : node.getGroupingElements()) {
                rewrittenGroupBy.add((Object)((GroupingElement)this.process((Node)ExpressionUtils.removeGroupingElementPrefix(element, this.removablePrefix), context)));
            }
            return new GroupBy(node.isDistinct(), (List)rewrittenGroupBy.build());
        }

        protected Node visitOrderBy(OrderBy node, Void context) {
            ImmutableList.Builder rewrittenOrderBy = ImmutableList.builder();
            for (SortItem sortItem : node.getSortItems()) {
                sortItem = ExpressionUtils.removeSortItemPrefix(sortItem, this.removablePrefix);
                if (!this.materializedViewInfo.getBaseToViewColumnMap().containsKey(sortItem.getSortKey())) {
                    throw new IllegalStateException(String.format("Sort key %s is not present in materialized view select fields", sortItem.getSortKey()));
                }
                rewrittenOrderBy.add((Object)((SortItem)this.process((Node)sortItem, context)));
            }
            return new OrderBy((List)rewrittenOrderBy.build());
        }

        protected Node visitSortItem(SortItem node, Void context) {
            return new SortItem((Expression)this.process((Node)node.getSortKey(), context), node.getOrdering(), node.getNullOrdering());
        }

        protected Node visitSimpleGroupBy(SimpleGroupBy node, Void context) {
            ImmutableList.Builder rewrittenSimpleGroupBy = ImmutableList.builder();
            for (Expression column : node.getExpressions()) {
                rewrittenSimpleGroupBy.add((Object)((Expression)this.process((Node)ExpressionUtils.removeExpressionPrefix(column, this.removablePrefix), context)));
            }
            return new SimpleGroupBy((List)rewrittenSimpleGroupBy.build());
        }

        private boolean validateExpressionForGroupBy(Set<Expression> groupByOfMaterializedView, Expression expression) {
            boolean canRewrite = expression instanceof FunctionCall && (MaterializedViewUtils.ASSOCIATIVE_REWRITE_FUNCTIONS.contains(((FunctionCall)expression).getName()) || MaterializedViewUtils.validateNonAssociativeFunctionRewrite((FunctionCall)expression, this.materializedViewInfo.getBaseToViewColumnMap()));
            return groupByOfMaterializedView.contains(expression) || !this.materializedViewInfo.getBaseToViewColumnMap().containsKey(expression) && !canRewrite;
        }

        private FunctionCall rewriteCountAsSum(FunctionCall node, Expression derivedColumnName) {
            if (!node.getName().equals((Object)MaterializedViewUtils.COUNT)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Provided function was not COUNT", new Object[0]);
            }
            if (node.isDistinct()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "COUNT(DISTINCT) is not supported for materialized view query rewrite optimization", new Object[0]);
            }
            return new FunctionCall(MaterializedViewUtils.SUM, node.getWindow(), node.getFilter(), node.getOrderBy(), node.isDistinct(), node.isIgnoreNulls(), (List)ImmutableList.of((Object)derivedColumnName));
        }

        private RowExpression convertToRowExpression(Expression expression, Scope scope) {
            ExpressionAnalysis originalExpressionAnalysis = this.getExpressionAnalysis(expression, scope);
            Expression coercedMaybe = this.rewriteExpressionWithCoercions(expression, originalExpressionAnalysis);
            ExpressionAnalysis coercedExpressionAnalysis = this.getExpressionAnalysis(coercedMaybe, scope);
            return SqlToRowExpressionTranslator.translate(coercedMaybe, coercedExpressionAnalysis.getExpressionTypes(), (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), MaterializedViewQueryOptimizer.this.metadata.getFunctionAndTypeManager(), MaterializedViewQueryOptimizer.this.session);
        }

        ExpressionAnalysis getExpressionAnalysis(Expression expression, Scope scope) {
            return ExpressionAnalyzer.analyzeExpression(MaterializedViewQueryOptimizer.this.session, MaterializedViewQueryOptimizer.this.metadata, MaterializedViewQueryOptimizer.this.accessControl, MaterializedViewQueryOptimizer.this.sqlParser, scope, new Analysis(null, (Map)ImmutableMap.of(), false), expression, WarningCollector.NOOP);
        }

        private Expression rewriteExpressionWithCoercions(Expression expression, ExpressionAnalysis analysis) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new CoercionRewriter(analysis), (Expression)expression, null);
        }

        private Scope extractScope(Table table, QuerySpecification node, Expression whereClause) {
            QualifiedObjectName baseTableName = MetadataUtil.createQualifiedObjectName(MaterializedViewQueryOptimizer.this.session, (Node)table, table.getName(), MaterializedViewQueryOptimizer.this.metadata);
            Optional tableHandle = MaterializedViewQueryOptimizer.this.metadata.getMetadataResolver(MaterializedViewQueryOptimizer.this.session).getTableHandle(baseTableName);
            if (!tableHandle.isPresent()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table does not exist", new Object[0]);
            }
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ColumnHandle columnHandle : MaterializedViewQueryOptimizer.this.metadata.getColumnHandles(MaterializedViewQueryOptimizer.this.session, (TableHandle)tableHandle.get()).values()) {
                ColumnMetadata columnMetadata = MaterializedViewQueryOptimizer.this.metadata.getColumnMetadata(MaterializedViewQueryOptimizer.this.session, (TableHandle)tableHandle.get(), columnHandle);
                fields.add((Object)Field.newUnqualified((Optional)whereClause.getLocation(), (String)columnMetadata.getName(), (Type)columnMetadata.getType()));
            }
            return Scope.builder().withRelationType(RelationId.anonymous(), new RelationType((List)fields.build())).build();
        }

        private MaterializedViewStatus getMaterializedViewStatus(QuerySpecification querySpecification) {
            TupleDomain<String> baseQueryDomain = TupleDomain.all();
            if (querySpecification.getWhere().isPresent() && SystemSessionProperties.isMaterializedViewPartitionFilteringEnabled(MaterializedViewQueryOptimizer.this.session)) {
                Table table;
                Expression baseQueryWhereClause = (Expression)querySpecification.getWhere().get();
                Relation from = (Relation)querySpecification.getFrom().orElseThrow(() -> new IllegalStateException("from should be present"));
                if (from instanceof Table) {
                    table = (Table)querySpecification.getFrom().get();
                } else if (from instanceof AliasedRelation && ((AliasedRelation)from).getRelation() instanceof Table) {
                    table = (Table)((AliasedRelation)from).getRelation();
                } else {
                    throw new IllegalStateException("from should be either a Table or AliasedRelation with table source");
                }
                Scope filterScope = this.extractScope(table, querySpecification, baseQueryWhereClause);
                RowExpression rowExpression = this.convertToRowExpression(baseQueryWhereClause, filterScope);
                baseQueryDomain = MaterializedViewUtils.getDomainFromFilter(MaterializedViewQueryOptimizer.this.session, MaterializedViewQueryOptimizer.this.domainTranslator, rowExpression);
            }
            return MaterializedViewQueryOptimizer.this.metadataResolver.getMaterializedViewStatus(this.materializedViewName, (TupleDomain)baseQueryDomain);
        }

        private class CoercionRewriter
        extends ExpressionRewriter<Void> {
            private final ExpressionAnalysis analysis;

            CoercionRewriter(ExpressionAnalysis analysis) {
                this.analysis = analysis;
            }

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> expressionRewriter) {
                Expression rewrittenExpression = expressionRewriter.defaultRewrite(node, (Object)context);
                return this.coerceIfNecessary(node, rewrittenExpression);
            }

            private Expression coerceIfNecessary(Expression original, Expression rewritten) {
                Type coercion = this.analysis.getCoercion(original);
                if (coercion != null) {
                    rewritten = new Cast(original.getLocation(), rewritten, coercion.getTypeSignature().toString(), false, this.analysis.isTypeOnlyCoercion(original));
                }
                return rewritten;
            }
        }
    }
}

