/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.eventlistener.CTEInformation;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;

public class CTEInformationCollector {
    private final HashMap<String, CTEInformation> cteInformationMap = new HashMap();

    public void addCTEReference(String cteName, boolean isView, boolean isMaterialized) {
        this.addCTEReference(cteName, cteName, isView, isMaterialized);
    }

    public void addCTEReference(String cteName, String cteId, boolean isView, boolean isMaterialized) {
        this.cteInformationMap.putIfAbsent(cteId, new CTEInformation(cteName, cteId, 0, isView, isMaterialized));
        this.cteInformationMap.get(cteId).incrementReferences();
    }

    public List<CTEInformation> getCTEInformationList() {
        return ImmutableList.copyOf(this.cteInformationMap.values());
    }

    public HashMap<String, CTEInformation> getCteInformationMap() {
        return this.cteInformationMap;
    }

    public void disallowCteMaterialization(String cteId) {
        CTEInformation cteInfo = this.cteInformationMap.get(cteId);
        this.cteInformationMap.put(cteId, new CTEInformation(cteInfo.getCteName(), cteInfo.getCteId(), cteInfo.getNumberOfReferences(), cteInfo.getIsView(), false));
    }
}

