/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.PartitioningMetadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.NewTableLayout;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.AggregationFunctionImplementation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.CteMaterializationInfo;
import com.facebook.presto.spi.plan.ExchangeEncoding;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.StatisticAggregations;
import com.facebook.presto.spi.plan.TableFinishNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.planner.BasePlanFragmenter;
import com.facebook.presto.sql.planner.StatisticsAggregationPlanner;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TemporaryTableUtil {
    private TemporaryTableUtil() {
    }

    public static TableScanNode createTemporaryTableScan(Metadata metadata, Session session, PlanNodeIdAllocator idAllocator, Optional<SourceLocation> sourceLocation, TableHandle tableHandle, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap, Optional<PartitioningMetadata> expectedPartitioningMetadata, Optional<String> cteId) {
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        Map outputColumns = (Map)outputVariables.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), variableToColumnMap::get));
        Set outputColumnHandles = (Set)outputColumns.values().stream().map(ColumnMetadata::getName).map(columnHandles::get).collect(ImmutableSet.toImmutableSet());
        TableLayoutResult selectedLayout = metadata.getLayout(session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.of(outputColumnHandles));
        Verify.verify((boolean)selectedLayout.getUnenforcedConstraint().equals((Object)TupleDomain.all()), (String)"temporary table layout shouldn't enforce any constraints", (Object[])new Object[0]);
        Verify.verify((!selectedLayout.getLayout().getColumns().isPresent() ? 1 : 0) != 0, (String)"temporary table layout must provide all the columns", (Object[])new Object[0]);
        if (expectedPartitioningMetadata.isPresent()) {
            TableLayout.TablePartitioning expectedPartitioning = new TableLayout.TablePartitioning(expectedPartitioningMetadata.get().getPartitioningHandle(), (List)expectedPartitioningMetadata.get().getPartitionColumns().stream().map(columnHandles::get).collect(ImmutableList.toImmutableList()));
            Verify.verify((boolean)selectedLayout.getLayout().getTablePartitioning().equals(Optional.of(expectedPartitioning)), (String)"invalid temporary table partitioning", (Object[])new Object[0]);
        }
        Map assignments = (Map)outputVariables.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), variable -> (ColumnHandle)columnHandles.get(((ColumnMetadata)outputColumns.get(variable)).getName())));
        return new TableScanNode(sourceLocation, idAllocator.getNextId(), Optional.empty(), selectedLayout.getLayout().getNewTableHandle(), outputVariables, assignments, Collections.emptyList(), TupleDomain.all(), TupleDomain.all(), cteId.map(CteMaterializationInfo::new));
    }

    public static Map<VariableReferenceExpression, ColumnMetadata> assignTemporaryTableColumnNames(Metadata metadata, Session session, String catalogName, Collection<VariableReferenceExpression> outputVariables, Collection<VariableReferenceExpression> constantPartitioningVariables) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        int column = 0;
        for (VariableReferenceExpression outputVariable : Iterables.concat(outputVariables, constantPartitioningVariables)) {
            String columnName = String.format("_c%d_%s", column, outputVariable.getName());
            result.put((Object)outputVariable, (Object)ColumnMetadata.builder().setName(metadata.normalizeIdentifier(session, catalogName, columnName)).setType(outputVariable.getType()).build());
            ++column;
        }
        return result.build();
    }

    public static Map<VariableReferenceExpression, ColumnMetadata> assignTemporaryTableColumnNames(Metadata metadata, Session session, String catalogName, Collection<VariableReferenceExpression> outputVariables) {
        return TemporaryTableUtil.assignTemporaryTableColumnNames(metadata, session, catalogName, outputVariables, Collections.emptyList());
    }

    public static BasePlanFragmenter.PartitioningVariableAssignments assignPartitioningVariables(VariableAllocator variableAllocator, Partitioning partitioning) {
        ImmutableList.Builder variables = ImmutableList.builder();
        ImmutableMap.Builder constants = ImmutableMap.builder();
        for (RowExpression argument : partitioning.getArguments()) {
            VariableReferenceExpression variable;
            Preconditions.checkArgument((argument instanceof ConstantExpression || argument instanceof VariableReferenceExpression ? 1 : 0) != 0, (Object)String.format("Expect argument to be ConstantExpression or VariableReferenceExpression, got %s (%s)", argument.getClass(), argument));
            if (argument instanceof ConstantExpression) {
                variable = variableAllocator.newVariable(argument.getSourceLocation(), "constant_partition", argument.getType());
                constants.put((Object)variable, (Object)argument);
            } else {
                variable = (VariableReferenceExpression)argument;
            }
            variables.add((Object)variable);
        }
        return new BasePlanFragmenter.PartitioningVariableAssignments((List<VariableReferenceExpression>)variables.build(), (Map<VariableReferenceExpression, RowExpression>)constants.build());
    }

    public static TableFinishNode createTemporaryTableWriteWithoutExchanges(Metadata metadata, Session session, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, PlanNode source, TableHandle tableHandle, List<VariableReferenceExpression> outputs, Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap, VariableReferenceExpression outputVar, Optional<String> cteId) {
        SchemaTableName schemaTableName = metadata.getTableMetadata(session, tableHandle).getTable();
        TableWriterNode.InsertReference insertReference = new TableWriterNode.InsertReference(tableHandle, schemaTableName);
        List outputColumnNames = (List)outputs.stream().map(variableToColumnMap::get).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        Set outputNotNullColumnVariables = outputs.stream().filter(variable -> variableToColumnMap.get(variable) != null && !((ColumnMetadata)variableToColumnMap.get(variable)).isNullable()).collect(Collectors.toSet());
        Map columnNameToVariable = (Map)variableToColumnMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((ColumnMetadata)entry.getValue()).getName(), Map.Entry::getKey));
        return new TableFinishNode(source.getSourceLocation(), idAllocator.getNextId(), (PlanNode)new TableWriterNode(source.getSourceLocation(), idAllocator.getNextId(), source, Optional.of(insertReference), variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), variableAllocator.newVariable("fragments", (Type)VarbinaryType.VARBINARY), variableAllocator.newVariable("commitcontext", (Type)VarbinaryType.VARBINARY), outputs, outputColumnNames, outputNotNullColumnVariables, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(Boolean.TRUE)), Optional.of(insertReference), outputVar, Optional.empty(), Optional.empty(), cteId.map(CteMaterializationInfo::new));
    }

    public static TableFinishNode createTemporaryTableWriteWithExchanges(Metadata metadata, Session session, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, StatisticsAggregationPlanner statisticsAggregationPlanner, Optional<SourceLocation> sourceLocation, TableHandle tableHandle, Map<VariableReferenceExpression, ColumnMetadata> variableToColumnMap, List<VariableReferenceExpression> outputs, List<List<VariableReferenceExpression>> inputs, List<PlanNode> sources, Map<VariableReferenceExpression, RowExpression> constantExpressions, PartitioningMetadata partitioningMetadata) {
        if (!constantExpressions.isEmpty()) {
            ImmutableList constantVariables = ImmutableList.copyOf(constantExpressions.keySet());
            outputs = ImmutableList.builder().addAll(outputs).addAll((Iterable)constantVariables).build();
            inputs = (List)inputs.stream().map(arg_0 -> TemporaryTableUtil.lambda$createTemporaryTableWriteWithExchanges$3((List)constantVariables, arg_0)).collect(ImmutableList.toImmutableList());
            sources = (List)sources.stream().map(arg_0 -> TemporaryTableUtil.lambda$createTemporaryTableWriteWithExchanges$6((List)constantVariables, constantExpressions, idAllocator, arg_0)).collect(ImmutableList.toImmutableList());
        }
        NewTableLayout insertLayout = metadata.getInsertLayout(session, tableHandle).orElseThrow(() -> new IllegalArgumentException("insertLayout for the temporary table must be present"));
        PartitioningHandle partitioningHandle = partitioningMetadata.getPartitioningHandle();
        List<String> partitionColumns = partitioningMetadata.getPartitionColumns();
        ConnectorNewTableLayout expectedNewTableLayout = new ConnectorNewTableLayout(partitioningHandle.getConnectorHandle(), partitionColumns);
        Verify.verify((boolean)insertLayout.getLayout().equals((Object)expectedNewTableLayout), (String)"unexpected new table layout", (Object[])new Object[0]);
        Map columnNameToVariable = (Map)variableToColumnMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((ColumnMetadata)entry.getValue()).getName(), Map.Entry::getKey));
        List partitioningVariables = (List)partitionColumns.stream().map(columnNameToVariable::get).collect(ImmutableList.toImmutableList());
        List outputColumnNames = (List)outputs.stream().map(variableToColumnMap::get).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        Set outputNotNullColumnVariables = outputs.stream().filter(variable -> variableToColumnMap.get(variable) != null && !((ColumnMetadata)variableToColumnMap.get(variable)).isNullable()).collect(Collectors.toSet());
        SchemaTableName schemaTableName = metadata.getTableMetadata(session, tableHandle).getTable();
        TableWriterNode.InsertReference insertReference = new TableWriterNode.InsertReference(tableHandle, schemaTableName);
        PartitioningScheme partitioningScheme = new PartitioningScheme(Partitioning.create((PartitioningHandle)partitioningHandle, (Collection)partitioningVariables), (List)outputs, Optional.empty(), false, false, ExchangeEncoding.COLUMNAR, Optional.empty());
        ExchangeNode writerRemoteSource = new ExchangeNode(sourceLocation, idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.REMOTE_STREAMING, partitioningScheme, sources, inputs, false, Optional.empty());
        ExchangeNode writerSource = SystemSessionProperties.getTaskPartitionedWriterCount(session) == 1 ? ExchangeNode.gatheringExchange(idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, writerRemoteSource) : ExchangeNode.partitionedExchange(idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, writerRemoteSource, partitioningScheme);
        String catalogName = tableHandle.getConnectorId().getCatalogName();
        TableMetadata tableMetadata = metadata.getTableMetadata(session, tableHandle);
        TableStatisticsMetadata statisticsMetadata = metadata.getStatisticsCollectionMetadataForWrite(session, catalogName, tableMetadata.getMetadata());
        StatisticsAggregationPlanner.TableStatisticAggregation statisticsResult = statisticsAggregationPlanner.createStatisticsAggregation(statisticsMetadata, columnNameToVariable);
        StatisticAggregations.Parts aggregations = TemporaryTableUtil.splitIntoPartialAndFinal(statisticsResult.getAggregations(), variableAllocator, metadata.getFunctionAndTypeManager());
        boolean enableStatsCollectionForTemporaryTable = SystemSessionProperties.isEnableStatsCollectionForTemporaryTable(session);
        StatisticAggregations.Parts localAggregations = TemporaryTableUtil.splitIntoPartialAndIntermediate(aggregations.getPartialAggregation(), variableAllocator, metadata.getFunctionAndTypeManager());
        TableWriterMergeNode tableWriterMerge = new TableWriterMergeNode(sourceLocation, idAllocator.getNextId(), ExchangeNode.gatheringExchange(idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, (PlanNode)new TableWriterNode(sourceLocation, idAllocator.getNextId(), (PlanNode)writerSource, Optional.of(insertReference), variableAllocator.newVariable("partialrows", (Type)BigintType.BIGINT), variableAllocator.newVariable("partialfragments", (Type)VarbinaryType.VARBINARY), variableAllocator.newVariable("partialtablecommitcontext", (Type)VarbinaryType.VARBINARY), (List)outputs, outputColumnNames, outputNotNullColumnVariables, Optional.of(partitioningScheme), enableStatsCollectionForTemporaryTable ? Optional.of(localAggregations.getPartialAggregation()) : Optional.empty(), Optional.empty(), Optional.of(Boolean.TRUE))), variableAllocator.newVariable("intermediaterows", (Type)BigintType.BIGINT), variableAllocator.newVariable("intermediatefragments", (Type)VarbinaryType.VARBINARY), variableAllocator.newVariable("intermediatetablecommitcontext", (Type)VarbinaryType.VARBINARY), enableStatsCollectionForTemporaryTable ? Optional.of(localAggregations.getIntermediateAggregation()) : Optional.empty());
        return new TableFinishNode(sourceLocation, idAllocator.getNextId(), (PlanNode)ExchangeNode.ensureSourceOrderingGatheringExchange(idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, tableWriterMerge), Optional.of(insertReference), variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), enableStatsCollectionForTemporaryTable ? Optional.of(aggregations.getFinalAggregation()) : Optional.empty(), enableStatsCollectionForTemporaryTable ? Optional.of(statisticsResult.getDescriptor()) : Optional.empty(), Optional.empty());
    }

    public static StatisticAggregations.Parts splitIntoPartialAndFinal(StatisticAggregations statisticAggregations, VariableAllocator variableAllocator, FunctionAndTypeManager functionAndTypeManager) {
        return TemporaryTableUtil.split(statisticAggregations, variableAllocator, functionAndTypeManager, false);
    }

    public static StatisticAggregations.Parts splitIntoPartialAndIntermediate(StatisticAggregations statisticAggregations, VariableAllocator variableAllocator, FunctionAndTypeManager functionAndTypeManager) {
        return TemporaryTableUtil.split(statisticAggregations, variableAllocator, functionAndTypeManager, true);
    }

    private static StatisticAggregations.Parts split(StatisticAggregations statisticAggregations, VariableAllocator variableAllocator, FunctionAndTypeManager functionAndTypeManager, boolean intermediate) {
        ImmutableMap.Builder finalOrIntermediateAggregations = ImmutableMap.builder();
        ImmutableMap.Builder partialAggregations = ImmutableMap.builder();
        for (Map.Entry entry : statisticAggregations.getAggregations().entrySet()) {
            AggregationNode.Aggregation originalAggregation = (AggregationNode.Aggregation)entry.getValue();
            FunctionHandle functionHandle = originalAggregation.getFunctionHandle();
            AggregationFunctionImplementation function = functionAndTypeManager.getAggregateFunctionImplementation(functionHandle);
            VariableReferenceExpression partialVariable = variableAllocator.newVariable(((AggregationNode.Aggregation)entry.getValue()).getCall().getSourceLocation(), functionAndTypeManager.getFunctionMetadata(functionHandle).getName().getObjectName(), function.getIntermediateType());
            partialAggregations.put((Object)partialVariable, (Object)new AggregationNode.Aggregation(new CallExpression(originalAggregation.getCall().getSourceLocation(), originalAggregation.getCall().getDisplayName(), functionHandle, function.getIntermediateType(), originalAggregation.getArguments()), originalAggregation.getFilter(), originalAggregation.getOrderBy(), originalAggregation.isDistinct(), originalAggregation.getMask()));
            finalOrIntermediateAggregations.put((Object)((VariableReferenceExpression)entry.getKey()), (Object)new AggregationNode.Aggregation(new CallExpression(originalAggregation.getCall().getSourceLocation(), originalAggregation.getCall().getDisplayName(), functionHandle, intermediate ? function.getIntermediateType() : function.getFinalType(), (List)ImmutableList.of((Object)partialVariable)), Optional.empty(), Optional.empty(), false, Optional.empty()));
        }
        StatisticAggregations finalOrIntermediateAggregation = new StatisticAggregations((Map)finalOrIntermediateAggregations.build(), statisticAggregations.getGroupingVariables());
        return new StatisticAggregations.Parts(intermediate ? Optional.empty() : Optional.of(finalOrIntermediateAggregation), intermediate ? Optional.of(finalOrIntermediateAggregation) : Optional.empty(), new StatisticAggregations((Map)partialAggregations.build(), statisticAggregations.getGroupingVariables()));
    }

    private static /* synthetic */ ProjectNode lambda$createTemporaryTableWriteWithExchanges$6(List constantVariables, Map constantExpressions, PlanNodeIdAllocator idAllocator, PlanNode source) {
        Assignments.Builder assignments = Assignments.builder();
        source.getOutputVariables().forEach(variable -> assignments.put(variable, (RowExpression)new VariableReferenceExpression(variable.getSourceLocation(), variable.getName(), variable.getType())));
        constantVariables.forEach(variable -> assignments.put(variable, (RowExpression)constantExpressions.get(variable)));
        return new ProjectNode(source.getSourceLocation(), idAllocator.getNextId(), source, assignments.build(), ProjectNode.Locality.LOCAL);
    }

    private static /* synthetic */ ImmutableList lambda$createTemporaryTableWriteWithExchanges$3(List constantVariables, List input) {
        return ImmutableList.builder().addAll((Iterable)input).addAll((Iterable)constantVariables).build();
    }
}

