/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;

public final class Serialization {
    private static final char VARIABLE_TYPE_OPEN_BRACKET = '<';
    private static final char VARIABLE_TYPE_CLOSE_BRACKET = '>';

    private Serialization() {
    }

    public static class VariableReferenceExpressionDeserializer
    extends KeyDeserializer {
        private final TypeManager typeManager;

        @Inject
        public VariableReferenceExpressionDeserializer(TypeManager typeManager) {
            this.typeManager = typeManager;
        }

        public Object deserializeKey(String key, DeserializationContext ctx) {
            int p = key.indexOf(60);
            if (p <= 0 || key.charAt(key.length() - 1) != '>') {
                throw new IllegalArgumentException(String.format("Expect key to be of format 'name<type>', found %s", key));
            }
            return new VariableReferenceExpression(Optional.empty(), key.substring(0, p), this.typeManager.getType(TypeSignature.parseTypeSignature((String)key.substring(p + 1, key.length() - 1))));
        }
    }

    public static class VariableReferenceExpressionSerializer
    extends JsonSerializer<VariableReferenceExpression> {
        public void serialize(VariableReferenceExpression value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            jsonGenerator.writeFieldName(String.format("%s%s%s%s", value.getName(), Character.valueOf('<'), value.getType().getTypeSignature(), Character.valueOf('>')));
        }
    }

    public static class FunctionCallDeserializer
    extends JsonDeserializer<FunctionCall> {
        private final SqlParser sqlParser;

        @Inject
        public FunctionCallDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public FunctionCall deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return (FunctionCall)ExpressionUtils.rewriteIdentifiersToSymbolReferences(this.sqlParser.createExpression(jsonParser.getText()));
        }
    }

    public static class ExpressionDeserializer
    extends JsonDeserializer<Expression> {
        private final SqlParser sqlParser;

        @Inject
        public ExpressionDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public Expression deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return ExpressionUtils.rewriteIdentifiersToSymbolReferences(this.sqlParser.createExpression(jsonParser.getText()));
        }
    }

    public static class ExpressionSerializer
    extends JsonSerializer<Expression> {
        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(ExpressionFormatter.formatExpression((Expression)expression, Optional.empty()));
        }
    }
}

