/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.StatsRecordingPlanOptimizer;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;

public class OptimizerRuntimeTrackUtil {
    private OptimizerRuntimeTrackUtil() {
    }

    public static String getOptimizerNameForLog(Object optimizer) {
        Preconditions.checkArgument((optimizer instanceof PlanOptimizer || optimizer instanceof ConnectorPlanOptimizer ? 1 : 0) != 0);
        String optimizerName = optimizer.getClass().getSimpleName();
        if (optimizer instanceof StatsRecordingPlanOptimizer) {
            optimizerName = String.format("%s:%s", optimizerName, ((StatsRecordingPlanOptimizer)optimizer).getDelegate().getClass().getSimpleName());
        }
        return optimizerName;
    }

    public static boolean trackOptimizerRuntime(Session session, Object optimizer) {
        String optimizerString = SystemSessionProperties.getOptimizersToEnableVerboseRuntimeStats(session);
        if (optimizerString.isEmpty()) {
            return false;
        }
        List optimizers = Splitter.on((String)",").trimResults().splitToList((CharSequence)optimizerString);
        return optimizers.contains(OptimizerRuntimeTrackUtil.getOptimizerNameForLog(optimizer));
    }
}

