/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class NodeUtils {
    private NodeUtils() {
    }

    public static List<SortItem> getSortItemsFromOrderBy(Optional<OrderBy> orderBy) {
        return orderBy.map(OrderBy::getSortItems).orElse((List)ImmutableList.of());
    }

    public static Map<String, Expression> mapFromProperties(List<Property> properties) {
        HashMap<String, Expression> outputMap = new HashMap<String, Expression>();
        for (Property property : properties) {
            String key = property.getName().getValue();
            if (outputMap.containsKey(key)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, String.format("Duplicate property found: %s=%s and %s=%s", key, outputMap.get(key), key, property.getValue()));
            }
            outputMap.put(key, property.getValue());
        }
        return ImmutableMap.copyOf(outputMap);
    }
}

