/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.thrift;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.drift.TException;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.codec.metadata.DefaultThriftTypeReference;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.ThriftFieldExtractor;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.codec.metadata.ThriftTypeReference;
import com.facebook.drift.protocol.TField;
import com.facebook.drift.protocol.TProtocolException;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TStruct;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CustomCodecUtils {
    private CustomCodecUtils() {
    }

    public static ThriftStructMetadata createSyntheticMetadata(short fieldId, String fieldName, Class<?> originalType, Class<?> referencedType, ThriftType thriftType) {
        ThriftFieldMetadata fieldMetaData = new ThriftFieldMetadata(fieldId, false, false, ThriftField.Requiredness.NONE, (Map)ImmutableMap.of(), (ThriftTypeReference)new DefaultThriftTypeReference(thriftType), fieldName, FieldKind.THRIFT_FIELD, (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.of(new ThriftFieldExtractor(fieldId, fieldName, FieldKind.THRIFT_FIELD, originalType.getDeclaredFields()[0], referencedType)), Optional.empty());
        return new ThriftStructMetadata(originalType.getSimpleName() + "Wrapper", (Map)ImmutableMap.of(), originalType, null, ThriftStructMetadata.MetadataType.STRUCT, Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)fieldMetaData), Optional.empty(), (List)ImmutableList.of());
    }

    public static <T> T readSingleJsonField(TProtocolReader protocol, JsonCodec<T> jsonCodec, short fieldId, String fieldName) throws TException {
        protocol.readStructBegin();
        String jsonValue = null;
        TField field = protocol.readFieldBegin();
        while (field.getType() != 0) {
            if (field.getId() == fieldId) {
                if (field.getType() == 11) {
                    jsonValue = protocol.readString();
                } else {
                    throw new TProtocolException(String.format("Unexpected field type: %s for field %s", field.getType(), fieldName));
                }
            }
            protocol.readFieldEnd();
            field = protocol.readFieldBegin();
        }
        protocol.readStructEnd();
        if (jsonValue == null) {
            throw new TProtocolException(String.format("Required field '%s' was not found", fieldName));
        }
        return (T)jsonCodec.fromJson(jsonValue);
    }

    public static <T> void writeSingleJsonField(T value, TProtocolWriter protocol, JsonCodec<T> jsonCodec, short fieldId, String fieldName, String structName) throws TException {
        protocol.writeStructBegin(new TStruct(structName));
        protocol.writeFieldBegin(new TField(fieldName, 11, fieldId));
        protocol.writeString(jsonCodec.toJson(value));
        protocol.writeFieldEnd();
        protocol.writeFieldStop();
        protocol.writeStructEnd();
    }
}

