/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.spi.security.PrestoAuthenticator;
import com.facebook.presto.spi.security.PrestoAuthenticatorFactory;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;

public class PrestoAuthenticatorManager {
    private static final Logger log = Logger.get(PrestoAuthenticatorManager.class);
    private static final File CONFIG_FILE = new File("etc/presto-authenticator.properties");
    private static final String NAME_PROPERTY = "presto-authenticator.name";
    private final Map<String, PrestoAuthenticatorFactory> factories = new ConcurrentHashMap<String, PrestoAuthenticatorFactory>();
    private final AtomicReference<PrestoAuthenticator> authenticator = new AtomicReference();
    private final boolean customAuthenticatorRequested;

    @Inject
    public PrestoAuthenticatorManager(SecurityConfig securityConfig) {
        this.customAuthenticatorRequested = securityConfig.getAuthenticationTypes().contains((Object)SecurityConfig.AuthenticationType.CUSTOM);
    }

    public void addPrestoAuthenticatorFactory(PrestoAuthenticatorFactory factory) {
        Preconditions.checkArgument((this.factories.putIfAbsent(factory.getName(), factory) == null ? 1 : 0) != 0, (String)"Presto authenticator '%s' is already registered", (Object)factory.getName());
    }

    @VisibleForTesting
    public void loadAuthenticator(String authenticatorName) {
        PrestoAuthenticatorFactory factory = this.factories.get(authenticatorName);
        PrestoAuthenticator authenticator = factory.create((Map)ImmutableMap.of());
        this.authenticator.set(Objects.requireNonNull(authenticator, "authenticator is null"));
    }

    public void loadPrestoAuthenticator() throws Exception {
        if (!this.customAuthenticatorRequested) {
            return;
        }
        File configFileLocation = CONFIG_FILE.getAbsoluteFile();
        HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(configFileLocation));
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Presto authenticator configuration %s does not contain %s", (Object)configFileLocation, (Object)NAME_PROPERTY);
        log.info("-- Loading Presto authenticator --");
        PrestoAuthenticatorFactory factory = this.factories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Presto authenticator %s is not registered", (Object)name);
        PrestoAuthenticator authenticator = factory.create((Map)ImmutableMap.copyOf(properties));
        this.authenticator.set(Objects.requireNonNull(authenticator, "authenticator is null"));
        log.info("-- Loaded Presto authenticator %s --", new Object[]{name});
    }

    public PrestoAuthenticator getAuthenticator() {
        Preconditions.checkState((this.authenticator.get() != null ? 1 : 0) != 0, (Object)"authenticator was not loaded");
        return this.authenticator.get();
    }
}

