/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.spi.QueryId;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.RateLimiter;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class QueryBlockingRateLimiter {
    private final long rateLimiterBucketMaxSize;
    private final ListeningExecutorService rateLimiterExecutorService;
    private final LoadingCache<QueryId, RateLimiter> rateLimiterCache;
    private final CounterStat rateLimiterTriggeredCounter = new CounterStat();
    private final TimeStat rateLimiterBlockTime = new TimeStat();

    @Inject
    public QueryBlockingRateLimiter(QueryManagerConfig queryManagerConfig) {
        Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.rateLimiterBucketMaxSize = queryManagerConfig.getRateLimiterBucketMaxSize();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Threads.daemonThreadsNamed((String)"rate-limiter-listener"));
        this.rateLimiterExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this.rateLimiterCache = CacheBuilder.newBuilder().maximumSize((long)queryManagerConfig.getRateLimiterCacheLimit()).expireAfterAccess((long)queryManagerConfig.getRateLimiterCacheWindowMinutes(), TimeUnit.MINUTES).build(CacheLoader.from(key -> RateLimiter.create((double)this.rateLimiterBucketMaxSize)));
    }

    public ListenableFuture<Double> acquire(QueryId queryId) {
        if (this.rateLimiterBucketMaxSize < 0L) {
            return Futures.immediateFuture((Object)0.0);
        }
        if (queryId == null) {
            return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("queryId should not be null"));
        }
        RateLimiter rateLimiter = (RateLimiter)this.rateLimiterCache.getUnchecked((Object)queryId);
        if (rateLimiter.tryAcquire()) {
            return Futures.immediateFuture((Object)0.0);
        }
        ListenableFuture asyncTask = this.rateLimiterExecutorService.submit(() -> rateLimiter.acquire());
        this.rateLimiterTriggeredCounter.update(1L);
        return asyncTask;
    }

    @Managed
    @Nested
    public CounterStat getRateLimiterTriggeredCounter() {
        return this.rateLimiterTriggeredCounter;
    }

    public TimeStat getRateLimiterBlockTime() {
        return this.rateLimiterBlockTime;
    }

    public void addRateLimiterBlockTime(Duration duration) {
        this.rateLimiterBlockTime.add(duration);
    }

    @PreDestroy
    public void destroy() {
        this.rateLimiterExecutorService.shutdownNow();
    }
}

