/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public class TaskUpdateRequest {
    private final SessionRepresentation session;
    private final Map<String, String> extraCredentials;
    private final Optional<byte[]> fragment;
    private final List<TaskSource> sources;
    private final OutputBuffers outputIds;
    private final Optional<TableWriteInfo> tableWriteInfo;

    @ThriftConstructor
    @JsonCreator
    public TaskUpdateRequest(@JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="extraCredentials") Map<String, String> extraCredentials, @JsonProperty(value="fragment") Optional<byte[]> fragment, @JsonProperty(value="sources") List<TaskSource> sources, @JsonProperty(value="outputIds") OutputBuffers outputIds, @JsonProperty(value="tableWriteInfo") Optional<TableWriteInfo> tableWriteInfo) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(extraCredentials, "credentials is null");
        Objects.requireNonNull(fragment, "fragment is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(outputIds, "outputIds is null");
        Objects.requireNonNull(tableWriteInfo, "tableWriteInfo is null");
        this.session = session;
        this.extraCredentials = extraCredentials;
        this.fragment = fragment;
        this.sources = ImmutableList.copyOf(sources);
        this.outputIds = outputIds;
        this.tableWriteInfo = tableWriteInfo;
    }

    @JsonProperty
    @ThriftField(value=1)
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    @ThriftField(value=2)
    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty
    @ThriftField(value=3)
    public Optional<byte[]> getFragment() {
        return this.fragment;
    }

    @JsonProperty
    @ThriftField(value=4)
    public List<TaskSource> getSources() {
        return this.sources;
    }

    @JsonProperty
    @ThriftField(value=5)
    public OutputBuffers getOutputIds() {
        return this.outputIds;
    }

    @JsonProperty
    @ThriftField(value=6)
    public Optional<TableWriteInfo> getTableWriteInfo() {
        return this.tableWriteInfo;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).add("extraCredentials", this.extraCredentials.keySet()).add("fragment", this.fragment).add("sources", this.sources).add("outputIds", (Object)this.outputIds).toString();
    }
}

