/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.spi.NodePoolType;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class ServerConfig {
    public static final String POOL_TYPE = "pool_type";
    private boolean resourceManager;
    private boolean resourceManagerEnabled;
    private boolean catalogServer;
    private boolean coordinatorSidecar;
    private boolean coordinatorSidecarEnabled;
    private boolean catalogServerEnabled;
    private boolean coordinator = true;
    private String prestoVersion = this.getClass().getPackage().getImplementationVersion();
    private String dataSources;
    private boolean includeExceptionInResponse = true;
    private Duration gracePeriod = new Duration(2.0, TimeUnit.MINUTES);
    private boolean enhancedErrorReporting = true;
    private boolean queryResultsCompressionEnabled = true;
    private NodePoolType poolType = NodePoolType.DEFAULT;
    private Duration clusterStatsExpirationDuration = new Duration(0.0, TimeUnit.MILLISECONDS);
    private boolean nestedDataSerializationEnabled = true;
    private Duration clusterResourceGroupStateInfoExpirationDuration = new Duration(0.0, TimeUnit.MILLISECONDS);

    public boolean isResourceManager() {
        return this.resourceManager;
    }

    @Config(value="resource-manager")
    public ServerConfig setResourceManager(boolean resourceManager) {
        this.resourceManager = resourceManager;
        return this;
    }

    public boolean isResourceManagerEnabled() {
        return this.resourceManagerEnabled;
    }

    @Config(value="resource-manager-enabled")
    public ServerConfig setResourceManagerEnabled(boolean resourceManagerEnabled) {
        this.resourceManagerEnabled = resourceManagerEnabled;
        return this;
    }

    public boolean isCatalogServer() {
        return this.catalogServer;
    }

    @Config(value="catalog-server")
    public ServerConfig setCatalogServer(boolean catalogServer) {
        this.catalogServer = catalogServer;
        return this;
    }

    public boolean isCatalogServerEnabled() {
        return this.catalogServerEnabled;
    }

    @Config(value="catalog-server-enabled")
    public ServerConfig setCatalogServerEnabled(boolean catalogServerEnabled) {
        this.catalogServerEnabled = catalogServerEnabled;
        return this;
    }

    public boolean isCoordinatorSidecarEnabled() {
        return this.coordinatorSidecarEnabled;
    }

    @Config(value="coordinator-sidecar-enabled")
    public ServerConfig setCoordinatorSidecarEnabled(boolean coordinatorSidecarEnabled) {
        this.coordinatorSidecarEnabled = coordinatorSidecarEnabled;
        return this;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    @Config(value="coordinator")
    public ServerConfig setCoordinator(boolean coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    @NotNull(message="presto.version must be provided when it cannot be automatically determined")
    public @NotNull(message="presto.version must be provided when it cannot be automatically determined") String getPrestoVersion() {
        return this.prestoVersion;
    }

    @Config(value="presto.version")
    public ServerConfig setPrestoVersion(String prestoVersion) {
        this.prestoVersion = prestoVersion;
        return this;
    }

    @Deprecated
    public String getDataSources() {
        return this.dataSources;
    }

    @Deprecated
    @Config(value="datasources")
    public ServerConfig setDataSources(String dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public boolean isIncludeExceptionInResponse() {
        return this.includeExceptionInResponse;
    }

    @Config(value="http.include-exception-in-response")
    public ServerConfig setIncludeExceptionInResponse(boolean includeExceptionInResponse) {
        this.includeExceptionInResponse = includeExceptionInResponse;
        return this;
    }

    public Duration getGracePeriod() {
        return this.gracePeriod;
    }

    @Config(value="shutdown.grace-period")
    public ServerConfig setGracePeriod(Duration gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    public boolean isEnhancedErrorReporting() {
        return this.enhancedErrorReporting;
    }

    @Config(value="sql.parser.enhanced-error-reporting")
    public ServerConfig setEnhancedErrorReporting(boolean value) {
        this.enhancedErrorReporting = value;
        return this;
    }

    public boolean isQueryResultsCompressionEnabled() {
        return this.queryResultsCompressionEnabled;
    }

    @Config(value="query-results.compression-enabled")
    public ServerConfig setQueryResultsCompressionEnabled(boolean queryResultsCompressionEnabled) {
        this.queryResultsCompressionEnabled = queryResultsCompressionEnabled;
        return this;
    }

    public NodePoolType getPoolType() {
        return this.poolType;
    }

    @Config(value="pool-type")
    public ServerConfig setPoolType(NodePoolType poolType) {
        this.poolType = poolType;
        return this;
    }

    public Duration getClusterStatsExpirationDuration() {
        return this.clusterStatsExpirationDuration;
    }

    @Config(value="cluster-stats-expiration-duration")
    public ServerConfig setClusterStatsExpirationDuration(Duration clusterStatsExpirationDuration) {
        this.clusterStatsExpirationDuration = clusterStatsExpirationDuration;
        return this;
    }

    public boolean isNestedDataSerializationEnabled() {
        return this.nestedDataSerializationEnabled;
    }

    @Config(value="nested-data-serialization-enabled")
    public ServerConfig setNestedDataSerializationEnabled(boolean nestedDataSerializationEnabled) {
        this.nestedDataSerializationEnabled = nestedDataSerializationEnabled;
        return this;
    }

    public Duration getClusterResourceGroupStateInfoExpirationDuration() {
        return this.clusterResourceGroupStateInfoExpirationDuration;
    }

    @Config(value="cluster-resource-group-state-info-expiration-duration")
    public ServerConfig setClusterResourceGroupStateInfoExpirationDuration(Duration clusterResourceGroupStateInfoExpirationDuration) {
        this.clusterResourceGroupStateInfoExpirationDuration = clusterResourceGroupStateInfoExpirationDuration;
        return this;
    }
}

