/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.util.DateTimeUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@ThriftStruct
@Immutable
public class BasicQueryStats {
    private final long createTimeInMillis;
    private final long endTimeInMillis;
    private final Duration waitingForPrerequisitesTime;
    private final Duration queuedTime;
    private final Duration elapsedTime;
    private final Duration executionTime;
    private final Duration analysisTime;
    private final int runningTasks;
    private final int peakRunningTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final int totalNewDrivers;
    private final int queuedNewDrivers;
    private final int runningNewDrivers;
    private final int completedNewDrivers;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final double cumulativeUserMemory;
    private final double cumulativeTotalMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize peakTaskTotalMemoryReservation;
    private final DataSize peakNodeTotalMemoryReservation;
    private final Duration totalCpuTime;
    private final Duration totalScheduledTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize totalAllocation;
    private final OptionalDouble progressPercentage;

    public BasicQueryStats(long createTimeInMillis, long endTimeInMillis, Duration waitingForPrerequisitesTime, Duration queuedTime, Duration elapsedTime, Duration executionTime, Duration analysisTime, int runningTasks, int peakRunningTasks, int totalDrivers, int queuedDrivers, int runningDrivers, int completedDrivers, int totalNewDrivers, int queuedNewDrivers, int runningNewDrivers, int completedNewDrivers, int totalSplits, int queuedSplits, int runningSplits, int completedSplits, DataSize rawInputDataSize, long rawInputPositions, double cumulativeUserMemory, double cumulativeTotalMemory, DataSize userMemoryReservation, DataSize totalMemoryReservation, DataSize peakUserMemoryReservation, DataSize peakTotalMemoryReservation, DataSize peakTaskTotalMemoryReservation, DataSize peakNodeTotalMemoryReservation, Duration totalCpuTime, Duration totalScheduledTime, boolean fullyBlocked, Set<BlockedReason> blockedReasons, DataSize totalAllocation, OptionalDouble progressPercentage) {
        this.createTimeInMillis = createTimeInMillis;
        this.endTimeInMillis = endTimeInMillis;
        this.waitingForPrerequisitesTime = Objects.requireNonNull(waitingForPrerequisitesTime, "waitingForPrerequisitesTimex is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.runningTasks = runningTasks;
        this.peakRunningTasks = peakRunningTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((totalNewDrivers >= 0 ? 1 : 0) != 0, (Object)"totalNewDrivers is negative");
        this.totalNewDrivers = totalNewDrivers;
        Preconditions.checkArgument((queuedNewDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedNewDrivers is negative");
        this.queuedNewDrivers = queuedNewDrivers;
        Preconditions.checkArgument((runningNewDrivers >= 0 ? 1 : 0) != 0, (Object)"runningNewDrivers is negative");
        this.runningNewDrivers = runningNewDrivers;
        Preconditions.checkArgument((completedNewDrivers >= 0 ? 1 : 0) != 0, (Object)"completedNewDrivers is negative");
        this.completedNewDrivers = completedNewDrivers;
        Preconditions.checkArgument((totalSplits >= 0 ? 1 : 0) != 0, (Object)"totalSplits is negative");
        this.totalSplits = totalSplits;
        Preconditions.checkArgument((queuedSplits >= 0 ? 1 : 0) != 0, (Object)"queuedSplits is negative");
        this.queuedSplits = queuedSplits;
        Preconditions.checkArgument((runningSplits >= 0 ? 1 : 0) != 0, (Object)"runningSplits is negative");
        this.runningSplits = runningSplits;
        Preconditions.checkArgument((completedSplits >= 0 ? 1 : 0) != 0, (Object)"completedSplits is negative");
        this.completedSplits = completedSplits;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize);
        this.rawInputPositions = rawInputPositions;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.cumulativeTotalMemory = cumulativeTotalMemory;
        this.userMemoryReservation = userMemoryReservation;
        this.totalMemoryReservation = totalMemoryReservation;
        this.peakUserMemoryReservation = peakUserMemoryReservation;
        this.peakTotalMemoryReservation = peakTotalMemoryReservation;
        this.peakTaskTotalMemoryReservation = peakTaskTotalMemoryReservation;
        this.peakNodeTotalMemoryReservation = peakNodeTotalMemoryReservation;
        this.totalCpuTime = totalCpuTime;
        this.totalScheduledTime = totalScheduledTime;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.totalAllocation = Objects.requireNonNull(totalAllocation, "totalAllocation is null");
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
    }

    @ThriftConstructor
    @JsonCreator
    public BasicQueryStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="waitingForPrerequisitesTime") Duration waitingForPrerequisitesTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="executionTime") Duration executionTime, @JsonProperty(value="analysisTime") Duration analysisTime, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="peakRunningTasks") int peakRunningTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="totalNewDrivers") int totalNewDrivers, @JsonProperty(value="queuedNewDrivers") int queuedNewDrivers, @JsonProperty(value="runningNewDrivers") int runningNewDrivers, @JsonProperty(value="completedNewDrivers") int completedNewDrivers, @JsonProperty(value="totalSplits") int totalSplits, @JsonProperty(value="queuedSplits") int queuedSplits, @JsonProperty(value="runningSplits") int runningSplits, @JsonProperty(value="completedSplits") int completedSplits, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="cumulativeTotalMemory") double cumulativeTotalMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="peakTaskTotalMemoryReservation") DataSize peakTaskTotalMemoryReservation, @JsonProperty(value="peakNodeTotalMemoryReservation") DataSize peakNodeTotalMemoryReservation, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocation") DataSize totalAllocation, @JsonProperty(value="progressPercentage") OptionalDouble progressPercentage) {
        this(DateTimeUtils.toTimeStampInMillis(createTime), DateTimeUtils.toTimeStampInMillis(endTime), waitingForPrerequisitesTime, queuedTime, elapsedTime, executionTime, analysisTime, runningTasks, peakRunningTasks, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, totalNewDrivers, queuedNewDrivers, runningNewDrivers, completedNewDrivers, totalSplits, queuedSplits, runningSplits, completedSplits, rawInputDataSize, rawInputPositions, cumulativeUserMemory, cumulativeTotalMemory, userMemoryReservation, totalMemoryReservation, peakUserMemoryReservation, peakTotalMemoryReservation, peakTaskTotalMemoryReservation, peakNodeTotalMemoryReservation, totalCpuTime, totalScheduledTime, fullyBlocked, blockedReasons, totalAllocation, progressPercentage);
    }

    public BasicQueryStats(QueryStats queryStats) {
        this(queryStats.getCreateTimeInMillis(), queryStats.getEndTimeInMillis(), queryStats.getWaitingForPrerequisitesTime(), queryStats.getQueuedTime(), queryStats.getElapsedTime(), queryStats.getExecutionTime(), queryStats.getAnalysisTime(), queryStats.getRunningTasks(), queryStats.getPeakRunningTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getCompletedDrivers(), queryStats.getTotalNewDrivers(), queryStats.getQueuedNewDrivers(), queryStats.getRunningNewDrivers(), queryStats.getCompletedNewDrivers(), queryStats.getTotalSplits(), queryStats.getQueuedSplits(), queryStats.getRunningSplits(), queryStats.getCompletedSplits(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getCumulativeUserMemory(), queryStats.getCumulativeTotalMemory(), queryStats.getUserMemoryReservation(), queryStats.getTotalMemoryReservation(), queryStats.getPeakUserMemoryReservation(), queryStats.getPeakTotalMemoryReservation(), queryStats.getPeakTaskTotalMemory(), queryStats.getPeakNodeTotalMemory(), queryStats.getTotalCpuTime(), queryStats.getTotalScheduledTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getTotalAllocation(), queryStats.getProgressPercentage());
    }

    public static BasicQueryStats immediateFailureQueryStats() {
        long now = System.currentTimeMillis();
        return new BasicQueryStats(now, now, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, new DataSize(0.0, DataSize.Unit.BYTE), 0L, 0.0, 0.0, new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), new DataSize(0.0, DataSize.Unit.BYTE), OptionalDouble.empty());
    }

    @ThriftField(value=1)
    @JsonProperty
    public DateTime getCreateTime() {
        return new DateTime(this.createTimeInMillis);
    }

    public long getCreateTimeInMillis() {
        return this.createTimeInMillis;
    }

    @ThriftField(value=2)
    @JsonProperty
    public DateTime getEndTime() {
        return new DateTime(this.endTimeInMillis);
    }

    public long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    @ThriftField(value=3)
    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @ThriftField(value=4)
    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @ThriftField(value=5)
    @JsonProperty
    public Duration getExecutionTime() {
        return this.executionTime;
    }

    @ThriftField(value=6)
    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @ThriftField(value=7)
    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @ThriftField(value=8)
    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @ThriftField(value=9)
    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @ThriftField(value=10)
    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @ThriftField(value=11)
    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @ThriftField(value=12)
    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @ThriftField(value=13)
    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @ThriftField(value=14)
    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @ThriftField(value=15)
    public int getPeakRunningTasks() {
        return this.peakRunningTasks;
    }

    @ThriftField(value=16)
    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @ThriftField(value=17)
    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @ThriftField(value=18)
    @JsonProperty
    public DataSize getPeakTaskTotalMemoryReservation() {
        return this.peakTaskTotalMemoryReservation;
    }

    @ThriftField(value=19, name="peakNodeTotalMemoryReservation")
    @JsonProperty
    public DataSize getPeakNodeTotalMemoryReservation() {
        return this.peakNodeTotalMemoryReservation;
    }

    @ThriftField(value=20)
    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @ThriftField(value=21)
    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @ThriftField(value=22)
    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @ThriftField(value=23)
    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @ThriftField(value=24)
    @JsonProperty
    public DataSize getTotalAllocation() {
        return this.totalAllocation;
    }

    @ThriftField(value=25)
    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    @ThriftField(value=26)
    @JsonProperty
    public Duration getWaitingForPrerequisitesTime() {
        return this.waitingForPrerequisitesTime;
    }

    @ThriftField(value=27)
    @JsonProperty
    public double getCumulativeTotalMemory() {
        return this.cumulativeTotalMemory;
    }

    @ThriftField(value=28)
    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @ThriftField(value=29)
    @JsonProperty
    public Duration getAnalysisTime() {
        return this.analysisTime;
    }

    @ThriftField(value=30)
    @JsonProperty
    public int getTotalSplits() {
        return this.totalSplits;
    }

    @ThriftField(value=31)
    @JsonProperty
    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    @ThriftField(value=32)
    @JsonProperty
    public int getRunningSplits() {
        return this.runningSplits;
    }

    @ThriftField(value=33)
    @JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @ThriftField(value=34)
    @JsonProperty
    public int getTotalNewDrivers() {
        return this.totalNewDrivers;
    }

    @ThriftField(value=35)
    @JsonProperty
    public int getQueuedNewDrivers() {
        return this.queuedNewDrivers;
    }

    @ThriftField(value=36)
    @JsonProperty
    public int getRunningNewDrivers() {
        return this.runningNewDrivers;
    }

    @ThriftField(value=37)
    @JsonProperty
    public int getCompletedNewDrivers() {
        return this.completedNewDrivers;
    }
}

