/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.spi.security.ViewExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AllowAllSystemAccessControl
implements SystemAccessControl {
    public static final String NAME = "allow-all";
    private static final AllowAllSystemAccessControl INSTANCE = new AllowAllSystemAccessControl();

    public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query, Map<QualifiedObjectName, ViewDefinition> viewDefinitions, Map<QualifiedObjectName, MaterializedViewDefinition> materializedViewDefinitions) {
    }

    public AuthorizedIdentity selectAuthorizedIdentity(Identity identity, AccessControlContext context, String userName, List<X509Certificate> certificates) {
        return new AuthorizedIdentity(userName, "", Boolean.valueOf(true));
    }

    public void checkCanSetUser(Identity identity, AccessControlContext context, Optional<Principal> principal, String userName) {
    }

    public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
    }

    public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
    }

    public Set<String> filterCatalogs(Identity identity, AccessControlContext context, Set<String> catalogs) {
        return catalogs;
    }

    public void checkCanCreateSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
    }

    public void checkCanDropSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
    }

    public void checkCanRenameSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema, String newSchemaName) {
    }

    public void checkCanShowSchemas(Identity identity, AccessControlContext context, String catalogName) {
    }

    public Set<String> filterSchemas(Identity identity, AccessControlContext context, String catalogName, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanShowCreateTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanCreateTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanSetTableProperties(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanDropTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanRenameTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
    }

    public void checkCanShowTablesMetadata(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
    }

    public Set<SchemaTableName> filterTables(Identity identity, AccessControlContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumnsMetadata(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public List<ColumnMetadata> filterColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, List<ColumnMetadata> columns) {
        return columns;
    }

    public void checkCanAddColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanDropColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanRenameColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanInsertIntoTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanDeleteFromTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanTruncateTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanUpdateTableColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> updatedColumnNames) {
    }

    public void checkCanCreateView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
    }

    public void checkCanRenameView(Identity identity, AccessControlContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
    }

    public void checkCanDropView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
    }

    public void checkCanCreateViewWithSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, AccessControlContext context, String catalogName, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
    }

    public void checkCanRevokeTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
    }

    public void checkCanDropConstraint(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public void checkCanAddConstraint(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
    }

    public List<ViewExpression> getRowFilters(Identity identity, AccessControlContext context, CatalogSchemaTableName tableName) {
        return ImmutableList.of();
    }

    public Map<ColumnMetadata, ViewExpression> getColumnMasks(Identity identity, AccessControlContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        return ImmutableMap.of();
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return AllowAllSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Objects.requireNonNull(config, "config is null");
            Preconditions.checkArgument((boolean)config.isEmpty(), (Object)"This access controller does not support any configuration properties");
            return INSTANCE;
        }
    }
}

