/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceGroupService;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.resourcemanager.ResourceManagerInconsistentException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.inject.Inject;

public class ResourceManagerResourceGroupService
implements ResourceGroupService {
    private final DriftClient<ResourceManagerClient> resourceManagerClient;
    private final InternalNodeManager internalNodeManager;
    private final Function<InternalNode, List<ResourceGroupRuntimeInfo>> cache;
    private final Executor executor = Executors.newCachedThreadPool();
    private final Boolean resourceGroupServiceCacheEnable;

    @Inject
    public ResourceManagerResourceGroupService(@ForResourceManager DriftClient<ResourceManagerClient> resourceManagerClient, ResourceManagerConfig resourceManagerConfig, InternalNodeManager internalNodeManager) {
        this.resourceManagerClient = Objects.requireNonNull(resourceManagerClient, "resourceManagerService is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        Duration cacheExpireDuration = Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null").getResourceGroupServiceCacheExpireInterval();
        Duration cacheRefreshDuration = resourceManagerConfig.getResourceGroupServiceCacheRefreshInterval();
        this.resourceGroupServiceCacheEnable = resourceManagerConfig.getResourceGroupServiceCacheEnabled();
        this.cache = this.resourceGroupServiceCacheEnable != false ? CacheBuilder.newBuilder().expireAfterWrite(cacheExpireDuration.roundTo(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).refreshAfterWrite(cacheRefreshDuration.roundTo(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<InternalNode, List<ResourceGroupRuntimeInfo>>(){

            public List<ResourceGroupRuntimeInfo> load(InternalNode internalNode) throws ResourceManagerInconsistentException {
                return ResourceManagerResourceGroupService.this.getResourceGroupInfos(internalNode);
            }
        }, (Executor)this.executor)) : internalNode -> this.getResourceGroupInfos((InternalNode)internalNode);
    }

    @Override
    public List<ResourceGroupRuntimeInfo> getResourceGroupInfo() throws ResourceManagerInconsistentException {
        InternalNode currentNode = this.internalNodeManager.getCurrentNode();
        return this.cache.apply(currentNode);
    }

    private List<ResourceGroupRuntimeInfo> getResourceGroupInfos(InternalNode internalNode) throws ResourceManagerInconsistentException {
        return ((ResourceManagerClient)this.resourceManagerClient.get()).getResourceGroupInfo(internalNode.getNodeIdentifier());
    }
}

