/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.RaftConfig;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.BaseStateMachine;

public class RatisServer {
    private final InternalNodeManager internalNodeManager;
    private final String id;
    private final String groupId;
    private final int port;
    private final String storageDir;

    @Inject
    public RatisServer(InternalNodeManager internalNodeManager, RaftConfig raftConfig) {
        Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.internalNodeManager = internalNodeManager;
        this.id = internalNodeManager.getCurrentNode().getNodeIdentifier();
        Objects.requireNonNull(raftConfig, "raftConfig is null");
        this.groupId = raftConfig.getGroupId();
        this.port = raftConfig.getPort();
        this.storageDir = raftConfig.getStorageDir();
    }

    public RaftPeer[] getPeers() {
        Set<InternalNode> resourceManagers = this.internalNodeManager.getResourceManagers();
        return (RaftPeer[])resourceManagers.stream().map(resourceManager -> {
            RaftPeer.Builder builder = RaftPeer.newBuilder();
            builder.setId(RaftPeerId.valueOf((String)resourceManager.getNodeIdentifier())).setAddress(resourceManager.getHost() + ":" + resourceManager.getRaftPort().getAsInt());
            return builder.build();
        }).toArray(RaftPeer[]::new);
    }

    @PostConstruct
    public void start() throws Exception {
        this.run();
    }

    public void run() throws Exception {
        RaftProperties properties = new RaftProperties();
        GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.port);
        File storage = new File(this.storageDir + "/" + this.id);
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(storage));
        RaftGroup raftGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.valueOf((UUID)UUID.nameUUIDFromBytes(this.groupId.getBytes())), (RaftPeer[])this.getPeers());
        RaftServer raftServer = RaftServer.newBuilder().setServerId(RaftPeerId.valueOf((String)this.id)).setProperties(properties).setGroup(raftGroup).setStateMachine((StateMachine)new BaseStateMachine()).build();
        raftServer.start();
    }
}

