/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.ValueWindowFunction;
import com.facebook.presto.spi.function.WindowFunctionSignature;
import com.facebook.presto.spi.function.WindowFunctionSignatures;
import com.facebook.presto.util.Failures;
import java.util.List;

@WindowFunctionSignatures(value={@WindowFunctionSignature(name="lag", typeVariable="T", returnType="T", argumentTypes={"T"}), @WindowFunctionSignature(name="lag", typeVariable="T", returnType="T", argumentTypes={"T", "bigint"}), @WindowFunctionSignature(name="lag", typeVariable="T", returnType="T", argumentTypes={"T", "bigint", "T"})})
public class LagFunction
extends ValueWindowFunction {
    private final int valueChannel;
    private final int offsetChannel;
    private final int defaultChannel;

    public LagFunction(List<Integer> argumentChannels) {
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.size() > 1 ? argumentChannels.get(1) : -1;
        this.defaultChannel = argumentChannels.size() > 2 ? argumentChannels.get(2) : -1;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (this.offsetChannel >= 0 && this.windowIndex.isNull(this.offsetChannel, currentPosition)) {
            output.appendNull();
        } else {
            long valuePosition;
            long offset = this.offsetChannel < 0 ? 1L : this.windowIndex.getLong(this.offsetChannel, currentPosition);
            Failures.checkCondition(offset >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 0", new Object[0]);
            if (this.ignoreNulls && offset > 0L) {
                long count = 0L;
                valuePosition = currentPosition - 1;
                while (this.withinPartition(valuePosition, currentPosition) && (this.windowIndex.isNull(this.valueChannel, Math.toIntExact(valuePosition)) || ++count != offset)) {
                    --valuePosition;
                }
            } else {
                valuePosition = (long)currentPosition - offset;
            }
            if (this.withinPartition(valuePosition, currentPosition)) {
                this.windowIndex.appendTo(this.valueChannel, Math.toIntExact(valuePosition), output);
            } else if (this.defaultChannel >= 0) {
                this.windowIndex.appendTo(this.defaultChannel, currentPosition, output);
            } else {
                output.appendNull();
            }
        }
    }

    private boolean withinPartition(long valuePosition, long currentPosition) {
        return valuePosition >= 0L && valuePosition <= currentPosition;
    }
}

