/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.ParametricImplementationsGroup;
import com.facebook.presto.operator.annotations.FunctionsParserHelper;
import com.facebook.presto.operator.scalar.ParametricScalar;
import com.facebook.presto.operator.scalar.annotations.OperatorValidator;
import com.facebook.presto.operator.scalar.annotations.ParametricScalarImplementation;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementationHeader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.CodegenScalarFunction;
import com.facebook.presto.spi.function.FunctionDescriptor;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ScalarFromAnnotationsParser {
    private ScalarFromAnnotationsParser() {
    }

    public static List<SqlScalarFunction> parseFunctionDefinition(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScalarHeaderAndMethods scalar : ScalarFromAnnotationsParser.findScalarsInFunctionDefinitionClass(clazz)) {
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(scalar, FunctionsParserHelper.findConstructor(clazz)));
        }
        return builder.build();
    }

    public static List<SqlScalarFunction> parseFunctionDefinitions(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScalarHeaderAndMethods methods : ScalarFromAnnotationsParser.findScalarsInFunctionSetClass(clazz)) {
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(methods, Optional.empty()));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionDefinitionClass(Class<?> annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<ScalarImplementationHeader> classHeaders = ScalarImplementationHeader.fromAnnotatedElement(annotated);
        Preconditions.checkArgument((!classHeaders.isEmpty() ? 1 : 0) != 0, (String)"Class [%s] that defines function must be annotated with @ScalarFunction or @ScalarOperator", (Object)annotated.getName());
        for (ScalarImplementationHeader header : classHeaders) {
            Set<Method> methods = FunctionsParserHelper.findPublicMethods(annotated, SqlType.class, ScalarFunction.class, ScalarOperator.class);
            Failures.checkCondition(!methods.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Parametric class [%s] does not have any annotated methods", annotated.getName());
            for (Method method : methods) {
                Preconditions.checkArgument((method.getAnnotation(ScalarFunction.class) == null ? 1 : 0) != 0, (String)"Parametric class method [%s] is annotated with @ScalarFunction", (Object)method);
                Preconditions.checkArgument((method.getAnnotation(ScalarOperator.class) == null ? 1 : 0) != 0, (String)"Parametric class method [%s] is annotated with @ScalarOperator", (Object)method);
            }
            builder.add((Object)new ScalarHeaderAndMethods(header, methods));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionSetClass(Class<?> annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : FunctionsParserHelper.findPublicMethods(annotated, (Set<Class<? extends Annotation>>)ImmutableSet.of(SqlType.class, ScalarFunction.class, ScalarOperator.class, FunctionDescriptor.class), (Set<Class<? extends Annotation>>)ImmutableSet.of(SqlInvokedScalarFunction.class, CodegenScalarFunction.class))) {
            Failures.checkCondition(method.getAnnotation(ScalarFunction.class) != null || method.getAnnotation(ScalarOperator.class) != null, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] annotated with @SqlType is missing @ScalarFunction or @ScalarOperator", method);
            for (ScalarImplementationHeader header : ScalarImplementationHeader.fromAnnotatedElement(method)) {
                builder.add((Object)new ScalarHeaderAndMethods(header, (Set<Method>)ImmutableSet.of((Object)method)));
            }
        }
        return builder.build();
    }

    private static SqlScalarFunction parseParametricScalar(ScalarHeaderAndMethods scalar, Optional<Constructor<?>> constructor) {
        ScalarImplementationHeader header = scalar.getHeader();
        HashMap<ParametricScalarImplementation.SpecializedSignature, ParametricScalarImplementation.Builder> signatures = new HashMap<ParametricScalarImplementation.SpecializedSignature, ParametricScalarImplementation.Builder>();
        for (Method method : scalar.getMethods()) {
            ParametricScalarImplementation.Builder builder;
            Object implementation = ParametricScalarImplementation.Parser.parseImplementation(header, method, constructor);
            FunctionsParserHelper.checkPushdownSubfieldArgIndex(method, ((ParametricScalarImplementation)implementation).getSignature(), header.getHeader().getComplexTypeFunctionDescriptor().getPushdownSubfieldArgIndex());
            if (!signatures.containsKey(((ParametricScalarImplementation)implementation).getSpecializedSignature())) {
                builder = new ParametricScalarImplementation.Builder(((ParametricScalarImplementation)implementation).getSignature(), ((ParametricScalarImplementation)implementation).getArgumentNativeContainerTypes(), ((ParametricScalarImplementation)implementation).getSpecializedTypeParameters(), ((ParametricScalarImplementation)implementation).getReturnNativeContainerType());
                signatures.put(((ParametricScalarImplementation)implementation).getSpecializedSignature(), builder);
                builder.addChoices((ParametricScalarImplementation)implementation);
                continue;
            }
            builder = (ParametricScalarImplementation.Builder)signatures.get(((ParametricScalarImplementation)implementation).getSpecializedSignature());
            builder.addChoices((ParametricScalarImplementation)implementation);
        }
        ParametricImplementationsGroup.Builder<ParametricScalarImplementation> implementationsBuilder = ParametricImplementationsGroup.builder();
        for (Object implementation : signatures.values()) {
            implementationsBuilder.addImplementation(((ParametricScalarImplementation.Builder)implementation).build());
        }
        ParametricImplementationsGroup<ParametricScalarImplementation> parametricImplementationsGroup = implementationsBuilder.build();
        Signature scalarSignature = parametricImplementationsGroup.getSignature();
        header.getOperatorType().ifPresent(operatorType -> OperatorValidator.validateOperator(operatorType, scalarSignature.getReturnType(), scalarSignature.getArgumentTypes()));
        return new ParametricScalar(scalarSignature, header.getHeader(), parametricImplementationsGroup);
    }

    private static class ScalarHeaderAndMethods {
        private final ScalarImplementationHeader header;
        private final Set<Method> methods;

        public ScalarHeaderAndMethods(ScalarImplementationHeader header, Set<Method> methods) {
            this.header = Objects.requireNonNull(header);
            this.methods = Objects.requireNonNull(methods);
        }

        public ScalarImplementationHeader getHeader() {
            return this.header;
        }

        public Set<Method> getMethods() {
            return this.methods;
        }
    }
}

