/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;

@ScalarFunction(value="map_subset")
@Description(value="returns a map where the keys are a subset of the given array of keys")
public final class MapSubsetFunction {
    private MapSubsetFunction() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="MAP(K,V)")
    public static Block mapSubset(@TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @TypeParameter(value="MAP(K,V)") Type mapType, @SqlType(value="MAP(K,V)") Block mapBlock, @SqlType(value="ARRAY(K)") Block keySubset) {
        if (mapBlock.getPositionCount() == 0) {
            return mapBlock;
        }
        TypedSet typedSet = new TypedSet(keyType, keySubset.getPositionCount(), "map_subset");
        for (int i = 0; i < keySubset.getPositionCount(); ++i) {
            if (keySubset.isNull(i)) continue;
            typedSet.add(keySubset, i);
        }
        int toFind = typedSet.size();
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, toFind);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        if (toFind > 0) {
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                if (!typedSet.contains(mapBlock, i)) continue;
                keyType.appendTo(mapBlock, i, blockBuilder);
                valueType.appendTo(mapBlock, i + 1, blockBuilder);
                if (--toFind == 0) break;
            }
        }
        mapBlockBuilder.closeEntry();
        return (Block)mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

