/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

public final class MapGenericEquality {
    private MapGenericEquality() {
    }

    public static Boolean genericEqual(Type keyType, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode, Block leftBlock, Block rightBlock, EqualityPredicate predicate) {
        if (leftBlock.getPositionCount() != rightBlock.getPositionCount()) {
            return false;
        }
        SingleMapBlock leftSingleMapLeftBlock = (SingleMapBlock)leftBlock;
        SingleMapBlock rightSingleMapBlock = (SingleMapBlock)rightBlock;
        boolean indeterminate = false;
        for (int position = 0; position < leftSingleMapLeftBlock.getPositionCount(); position += 2) {
            int rightPosition;
            Object key = TypeUtils.readNativeValue((Type)keyType, (Block)leftBlock, (int)position);
            int leftPosition = position + 1;
            try {
                rightPosition = rightSingleMapBlock.seekKey(key, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
            }
            catch (NotSupportedException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
            }
            if (rightPosition == -1) {
                return false;
            }
            try {
                Boolean result = predicate.equals(leftPosition, rightPosition);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }

    public static interface EqualityPredicate {
        public Boolean equals(int var1, int var2) throws Throwable;
    }
}

