/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.google.common.collect.ImmutableList;
import java.util.List;

@ScalarFunction(value="map_from_entries")
@Description(value="construct a map from an array of entries")
public final class MapFromEntriesFunction {
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MapFromEntriesFunction(@TypeParameter(value="map(K,V)") Type mapType) {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,V)")
    @SqlNullable
    public Block mapFromEntries(@TypeParameter(value="map(K,V)") MapType mapType, SqlFunctionProperties properties, @SqlType(value="array(row(K,V))") Block block) {
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType));
        int entryCount = block.getPositionCount();
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, block.getPositionCount());
        BlockBuilder resultBuilder = mapBlockBuilder.beginBlockEntry();
        TypedSet uniqueKeys = new TypedSet(keyType, entryCount, "map_from_entries");
        for (int i = 0; i < entryCount; ++i) {
            if (block.isNull(i)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map entry cannot be null");
            }
            Block rowBlock = rowType.getObject(block, i);
            if (rowBlock.isNull(0)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            if (!uniqueKeys.add(rowBlock, 0)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Duplicate keys (%s) are not allowed", keyType.getObjectValue(properties, rowBlock, 0)));
            }
            keyType.appendTo(rowBlock, 0, resultBuilder);
            valueType.appendTo(rowBlock, 1, resultBuilder);
        }
        mapBlockBuilder.closeEntry();
        return mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

