/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.Constraint;
import io.airlift.joni.Matcher;
import io.airlift.joni.Regex;
import io.airlift.joni.Region;
import io.airlift.joni.exception.ValueException;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public final class JoniRegexpFunctions {
    public static final String CLASS_NAME = "JoniRegexpFunctions";
    private static final Block EMPTY_BLOCK = VarcharType.VARCHAR.createBlockBuilder(null, 0).build();

    private JoniRegexpFunctions() {
    }

    @Description(value="returns whether the pattern is contained within the string")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean regexpLike(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern) {
        Matcher matcher;
        int offset;
        if (source.hasByteArray()) {
            offset = source.byteArrayOffset();
            matcher = pattern.matcher(source.byteArray(), offset, offset + source.length());
        } else {
            offset = 0;
            matcher = pattern.matcher(source.getBytes());
        }
        return JoniRegexpFunctions.getMatchingOffset(matcher, offset, offset + source.length()) != -1;
    }

    @Description(value="removes substrings matching a regular expression")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern) {
        return JoniRegexpFunctions.regexpReplace(source, pattern, Slices.EMPTY_SLICE);
    }

    @Description(value="replaces substrings matching a regular expression by given string")
    @ScalarFunction
    @LiteralParameters(value={"x", "y", "z"})
    @Constraint(variable="z", expression="min(2147483647, x + max(x * y / 2, y) * (x + 1))")
    @SqlType(value="varchar(z)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern, @SqlType(value="varchar(y)") Slice replacement) {
        int offset;
        Matcher matcher = pattern.matcher(source.getBytes());
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(source.length() + replacement.length() * 5);
        int lastEnd = 0;
        int nextStart = 0;
        while ((offset = JoniRegexpFunctions.getMatchingOffset(matcher, nextStart, source.length())) != -1) {
            nextStart = matcher.getEnd() == matcher.getBegin() ? matcher.getEnd() + 1 : matcher.getEnd();
            Slice sliceBetweenReplacements = source.slice(lastEnd, matcher.getBegin() - lastEnd);
            lastEnd = matcher.getEnd();
            sliceOutput.appendBytes(sliceBetweenReplacements);
            JoniRegexpFunctions.appendReplacement((SliceOutput)sliceOutput, source, pattern, matcher.getEagerRegion(), replacement);
        }
        sliceOutput.appendBytes(source.slice(lastEnd, source.length() - lastEnd));
        return sliceOutput.slice();
    }

    private static void appendReplacement(SliceOutput result, Slice source, Regex pattern, Region region, Slice replacement) {
        int idx = 0;
        while (idx < replacement.length()) {
            byte nextByte = replacement.getByte(idx);
            if (nextByte == 36) {
                int backref;
                if (++idx == replacement.length()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Illegal replacement sequence: " + replacement.toStringUtf8());
                }
                nextByte = replacement.getByte(idx);
                if (nextByte == 123) {
                    int startCursor = ++idx;
                    while (idx < replacement.length() && (nextByte = replacement.getByte(idx)) != 125) {
                        ++idx;
                    }
                    byte[] groupName = replacement.getBytes(startCursor, idx - startCursor);
                    try {
                        backref = pattern.nameToBackrefNumber(groupName, 0, groupName.length, region);
                    }
                    catch (ValueException e) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Illegal replacement sequence: unknown group { " + new String(groupName, StandardCharsets.UTF_8) + " }");
                    }
                    ++idx;
                } else {
                    int newBackref;
                    int nextDigit;
                    backref = nextByte - 48;
                    if (backref < 0 || backref > 9) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Illegal replacement sequence: " + replacement.toStringUtf8());
                    }
                    if (region.numRegs <= backref) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Illegal replacement sequence: unknown group " + backref);
                    }
                    ++idx;
                    while (idx < replacement.length() && (nextDigit = replacement.getByte(idx) - 48) >= 0 && nextDigit <= 9 && region.numRegs > (newBackref = backref * 10 + nextDigit)) {
                        backref = newBackref;
                        ++idx;
                    }
                }
                int beg = region.beg[backref];
                int end = region.end[backref];
                if (beg == -1 || end == -1) continue;
                result.appendBytes(source.slice(beg, end - beg));
                continue;
            }
            if (nextByte == 92) {
                if (++idx == replacement.length()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Illegal replacement sequence: " + replacement.toStringUtf8());
                }
                nextByte = replacement.getByte(idx);
            }
            result.appendByte((int)nextByte);
            ++idx;
        }
    }

    @Description(value="string(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array(varchar(x))")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern) {
        return JoniRegexpFunctions.regexpExtractAll(source, pattern, 0L);
    }

    @Description(value="group(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array(varchar(x))")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern, @SqlType(value="bigint") long groupIndex) {
        int nextStart;
        Matcher matcher = pattern.matcher(source.getBytes());
        int offset = JoniRegexpFunctions.getMatchingOffset(matcher, nextStart = 0, source.length(), false);
        if (offset == -1) {
            return EMPTY_BLOCK;
        }
        JoniRegexpFunctions.validateGroup(groupIndex, matcher.getEagerRegion());
        ArrayList<Integer> matches = new ArrayList<Integer>(10);
        int group = Math.toIntExact(groupIndex);
        do {
            int beg = matcher.getBegin();
            int end = matcher.getEnd();
            nextStart = end == beg ? beg + 1 : end;
            Region region = matcher.getEagerRegion();
            matches.add(region.beg[group]);
            matches.add(region.end[group]);
        } while ((offset = JoniRegexpFunctions.getMatchingOffset(matcher, nextStart, source.length(), false)) != -1);
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, matches.size());
        for (int i = 0; i < matches.size(); i += 2) {
            int beg = (Integer)matches.get(i);
            int end = (Integer)matches.get(i + 1);
            if (beg == -1 || end == -1) {
                blockBuilder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeSlice(blockBuilder, source, beg, end - beg);
        }
        return blockBuilder;
    }

    @SqlNullable
    @Description(value="string extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern) {
        return JoniRegexpFunctions.regexpExtract(source, pattern, 0L);
    }

    @SqlNullable
    @Description(value="returns regex group of extracted string with a pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern, @SqlType(value="bigint") long groupIndex) {
        Matcher matcher = pattern.matcher(source.getBytes());
        int group = Math.toIntExact(groupIndex);
        int offset = JoniRegexpFunctions.getMatchingOffset(matcher, 0, source.length(), false);
        if (offset == -1) {
            return null;
        }
        JoniRegexpFunctions.validateGroup(groupIndex, matcher.getEagerRegion());
        Region region = matcher.getEagerRegion();
        int beg = region.beg[group];
        int end = region.end[group];
        if (beg == -1) {
            return null;
        }
        return source.slice(beg, end - beg);
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @Description(value="returns array of strings split by pattern")
    @SqlType(value="array(varchar(x))")
    public static Block regexpSplit(@SqlType(value="varchar(x)") Slice source, @SqlType(value="JoniRegExp") Regex pattern) {
        Matcher matcher = pattern.matcher(source.getBytes());
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 32);
        int lastEnd = 0;
        int nextStart = 0;
        int offset = JoniRegexpFunctions.getMatchingOffset(matcher, nextStart, source.length());
        if (offset == -1) {
            VarcharType.VARCHAR.writeSlice(blockBuilder, source);
            return blockBuilder.build();
        }
        do {
            nextStart = matcher.getEnd() == matcher.getBegin() ? matcher.getEnd() + 1 : matcher.getEnd();
            VarcharType.VARCHAR.writeSlice(blockBuilder, source, lastEnd, matcher.getBegin() - lastEnd);
            lastEnd = matcher.getEnd();
        } while ((offset = JoniRegexpFunctions.getMatchingOffset(matcher, nextStart, source.length())) != -1);
        VarcharType.VARCHAR.writeSlice(blockBuilder, source.slice(lastEnd, source.length() - lastEnd));
        return blockBuilder.build();
    }

    private static int getMatchingOffset(Matcher matcher, int at, int range) {
        return JoniRegexpFunctions.getMatchingOffset(matcher, at, range, true);
    }

    private static int getMatchingOffset(Matcher matcher, int at, int range, boolean noGroups) {
        try {
            return matcher.searchInterruptible(at, range, noGroups ? 128 : 0);
        }
        catch (InterruptedException interruptedException) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Regexp matching interrupted");
        }
    }

    private static void validateGroup(long group, Region region) {
        if (group < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Group cannot be negative");
        }
        if (group > (long)(region.numRegs - 1)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Pattern has %d groups. Cannot access group %d", region.numRegs - 1, group));
        }
    }
}

