/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import com.google.common.base.Defaults;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="arrays_overlap")
@Description(value="Returns true if arrays have common elements")
public final class ArraysOverlapFunction {
    private static final int NESTED_LOOP_THRESHOLD = 200;

    private ArraysOverlapFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean arraysOverlap(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"T", "T"}) MethodHandle elementIsDistinctFrom, @SqlType(value="array(T)") Block leftArray, @SqlType(value="array(T)") Block rightArray) {
        if (leftArray.getPositionCount() == 0 || rightArray.getPositionCount() == 0) {
            return false;
        }
        if (Math.max(rightArray.getPositionCount(), leftArray.getPositionCount()) >= 200) {
            return ArraysOverlapFunction.arraysOverlapSetBased(elementType, leftArray, rightArray);
        }
        boolean hasNull = false;
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            if (leftArray.isNull(i)) {
                hasNull = true;
                continue;
            }
            for (int j = 0; j < rightArray.getPositionCount(); ++j) {
                if (rightArray.isNull(j)) {
                    hasNull = true;
                    continue;
                }
                try {
                    Object secondValue;
                    boolean firstValueNull = leftArray.isNull(i);
                    Object firstValue = firstValueNull ? Defaults.defaultValue((Class)elementType.getJavaType()) : TypeUtils.readNativeValue((Type)elementType, (Block)leftArray, (int)i);
                    boolean secondValueNull = rightArray.isNull(j);
                    Object object = secondValue = secondValueNull ? Defaults.defaultValue((Class)elementType.getJavaType()) : TypeUtils.readNativeValue((Type)elementType, (Block)rightArray, (int)j);
                    if (elementIsDistinctFrom.invoke(firstValue, firstValueNull, secondValue, secondValueNull)) continue;
                    return true;
                }
                catch (Throwable t) {
                    throw Failures.internalError(t);
                }
            }
        }
        if (hasNull) {
            return null;
        }
        return false;
    }

    private static Boolean arraysOverlapSetBased(Type type, Block leftArray, Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0 || rightPositionCount == 0) {
            return false;
        }
        Block lookArray = leftArray;
        Block itrArray = rightArray;
        if (leftPositionCount > rightPositionCount) {
            lookArray = rightArray;
            itrArray = leftArray;
        }
        boolean itrArrHasNull = false;
        TypedSet typedSet = new TypedSet(type, lookArray.getPositionCount(), "arraysOverlap");
        for (i = 0; i < lookArray.getPositionCount(); ++i) {
            typedSet.add(lookArray, i);
        }
        for (i = 0; i < itrArray.getPositionCount(); ++i) {
            if (itrArray.isNull(i)) {
                itrArrHasNull = true;
                continue;
            }
            if (!typedSet.contains(itrArray, i)) continue;
            return true;
        }
        if (itrArrHasNull || typedSet.isContainNullElements()) {
            return null;
        }
        return false;
    }
}

