/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.OptimizedTypedSet;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_union")
@Description(value="Union elements of the two given arrays")
public final class ArrayUnionFunction {
    private ArrayUnionFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block union(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"E", "E"}) MethodHandle elementIsDistinctFrom, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int leftArrayCount = leftArray.getPositionCount();
        int rightArrayCount = rightArray.getPositionCount();
        OptimizedTypedSet typedSet = new OptimizedTypedSet(type, elementIsDistinctFrom, leftArrayCount + rightArrayCount);
        typedSet.union(leftArray);
        typedSet.union(rightArray);
        return typedSet.getBlock();
    }
}

