/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@Description(value="Returns the position of the first occurrence of the given value in array (or 0 if not found)")
@ScalarFunction(value="array_position")
public class ArrayPositionWithIndexFunction {
    protected ArrayPositionWithIndexFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPositionWithIndex(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") boolean element, @SqlType(value="bigint") long instance) {
        int size = array.getPositionCount();
        int instancesFound = 0;
        if (instance == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "0 is an invalid instance position for array_position.");
        }
        int startIndex = instance > 0L ? 0 : size - 1;
        int stopIndex = instance > 0L ? size : -1;
        int stepSize = instance > 0L ? 1 : -1;
        instance = Math.abs(instance);
        for (int i = startIndex; i != stopIndex; i += stepSize) {
            if (array.isNull(i)) continue;
            try {
                boolean arrayValue = type.getBoolean(array, i);
                Boolean result = equalMethodHandle.invoke(arrayValue, element);
                ArrayPositionWithIndexFunction.checkNotIndeterminate(result);
                if (!result.booleanValue() || (long)(++instancesFound) != instance) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPositionWithIndex(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") long element, @SqlType(value="bigint") long instance) {
        int size = array.getPositionCount();
        int instancesFound = 0;
        if (instance == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "array_position cannot take a 0-valued instance argument.");
        }
        int startIndex = instance > 0L ? 0 : size - 1;
        int stopIndex = instance > 0L ? size : -1;
        int stepSize = instance > 0L ? 1 : -1;
        instance = Math.abs(instance);
        for (int i = startIndex; i != stopIndex; i += stepSize) {
            if (array.isNull(i)) continue;
            try {
                long arrayValue = type.getLong(array, i);
                Boolean result = equalMethodHandle.invoke(arrayValue, element);
                ArrayPositionWithIndexFunction.checkNotIndeterminate(result);
                if (!result.booleanValue() || (long)(++instancesFound) != instance) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPositionWithIndex(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") double element, @SqlType(value="bigint") long instance) {
        int size = array.getPositionCount();
        int instancesFound = 0;
        if (instance == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "array_position cannot take a 0-valued instance argument.");
        }
        int startIndex = instance > 0L ? 0 : size - 1;
        int stopIndex = instance > 0L ? size : -1;
        int stepSize = instance > 0L ? 1 : -1;
        instance = Math.abs(instance);
        for (int i = startIndex; i != stopIndex; i += stepSize) {
            if (array.isNull(i)) continue;
            try {
                double arrayValue = type.getDouble(array, i);
                Boolean result = equalMethodHandle.invoke(arrayValue, element);
                ArrayPositionWithIndexFunction.checkNotIndeterminate(result);
                if (!result.booleanValue() || (long)(++instancesFound) != instance) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPositionWithIndex(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Slice element, @SqlType(value="bigint") long instance) {
        int size = array.getPositionCount();
        int instancesFound = 0;
        if (instance == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "array_position cannot take a 0-valued instance argument.");
        }
        int startIndex = instance > 0L ? 0 : size - 1;
        int stopIndex = instance > 0L ? size : -1;
        int stepSize = instance > 0L ? 1 : -1;
        instance = Math.abs(instance);
        for (int i = startIndex; i != stopIndex; i += stepSize) {
            if (array.isNull(i)) continue;
            try {
                Slice arrayValue = type.getSlice(array, i);
                Boolean result = equalMethodHandle.invoke(arrayValue, element);
                ArrayPositionWithIndexFunction.checkNotIndeterminate(result);
                if (!result.booleanValue() || (long)(++instancesFound) != instance) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPositionWithIndex(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Block element, @SqlType(value="bigint") long instance) {
        int size = array.getPositionCount();
        int instancesFound = 0;
        if (instance == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "array_position cannot take a 0-valued instance argument.");
        }
        int startIndex = instance > 0L ? 0 : size - 1;
        int stopIndex = instance > 0L ? size : -1;
        int stepSize = instance > 0L ? 1 : -1;
        instance = Math.abs(instance);
        for (int i = startIndex; i != stopIndex; i += stepSize) {
            if (array.isNull(i)) continue;
            try {
                Object arrayValue = type.getObject(array, i);
                Boolean result = equalMethodHandle.invoke(arrayValue, element);
                ArrayPositionWithIndexFunction.checkNotIndeterminate(result);
                if (!result.booleanValue() || (long)(++instancesFound) != instance) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "array_position does not support arrays with elements that are null or contain null");
        }
    }
}

